<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity
{
    /**
     * Authenticates a user based on username and password.
     * @return boolean whether authentication succeeds.
     */
    const ERROR_ACCOUNT_INACTIVE = 1000;

    private $_id;
    private $user;
    private $user_type_ref_id;
	

    public function authenticate($skipPassword = false)
    {
        $this->user = LoginMaster::model()->findByAttributes(array('username' => $this->username));

        if ($this->user === null)
            $this->errorCode = self::ERROR_USERNAME_INVALID;
        else {
            if (!$skipPassword && $this->user->pass_word !== md5($this->password))
                $this->errorCode = self::ERROR_PASSWORD_INVALID;
            else {
                if (!$this->user->is_active){					
                    $this->errorCode = self::ERROR_ACCOUNT_INACTIVE;
				}				
                else {
                    $this->user_type_ref_id = $this->user->user_type_ref_id;
                    $this->_id = $this->user->login_id;

                    $this->errorCode = self::ERROR_NONE;					
                    $subID = $this->getSubId();

                    Yii::app()->session->add('loginID', $this->_id);
                    Yii::app()->session->add('user_type_ref_id', $this->user_type_ref_id);
                    Yii::app()->session->add('sub_id', $subID);

                    $this->setState('user_type_ref_id', $this->user_type_ref_id);
                    $this->setState('sub_id', $subID);

                   $role = Yii::app()->authManager->getRoles($this->_id);
                   $userRole = array_keys($role)[0];
                   $this->setState('RbacUserRole', $userRole ?: '0');
                   $this->setState('FullName', CommonUtils::getFullName($this->_id));

                    // process shortlist entries in session
                    $shortList = new ShortListEngine();
                    $shortlistTest=new ShortListTestEngine();
                    $shortList->saveShortListFromSession();

                    $shortlistTest->saveShortListFromSession();
                    $this->registerSession();
                }
            }

             if ($this->errorCode != self::ERROR_USERNAME_INVALID) {
                $msg = $this->errorCode != self::ERROR_NONE ? 'Failure' : 'Success';
                $loginLogObj = new LoginLog();
                $loginLogObj->attributes = array('login_ref_id' => $this->user->login_id, 'ip_address' => Yii::app()->request->userHostAddress, 'login_status' => $msg);
                $loginLogObj->save(false);
            } 
        }

        return !$this->errorCode;

        /*
        $this->_id = $user->login_id;
        $this->errorCode=self::ERROR_NONE;
        $this->user = $user->attributes;
        $this->user_type_ref_id = $user->user_type_ref_id;

        Yii::app()->session['user_type_ref_id'] = $this->user_type_ref_id;
        Yii::app()->session['lang'] = 'EN';//$_POST['language']
        */
        /**
         * sub_id is the primary key of sub tables (tbl_admin, tbl_user_master etc.,)
         * By setting sub_id, we can use it as Yii::app()->user->sub_id,
         * which can be used in RBAC bizRule, or to directly access the respective primary key.
         */
        //$this->setState('sub_id', $this->getSubId());

    }

    public function getId()
    {
        return $this->_id;
    }

    public function getUser()
    {
        return $this->user;
    }

    /**
     * Returns the sub primary key (tbl_admin, tbl_user_master) based on login_ref_id
     * @return int|null
     */
    private function getSubId()
    {
        $subId = null;
        switch ($this->user_type_ref_id) {
            case '1':
                $obj = Student::model()->findByAttributes(array('login_ref_id' => $this->_id));
                $subId = $obj->user_id;
                break;
            case '2':
                $obj = TblSiDi::model()->findByAttributes(array('login_ref_id' => $this->_id));
                $subId = $obj->inst_id;
				
				//Added by Ravi
				//Ref: #1020
				if($subId == ''){
					$obj = Admin::model()->findByAttributes(array('login_ref_id' => $this->_id));
					$subId = $obj->si_ref_id;
				}
                break;
            case '3':
                Yii::import('application.modules.di.models.*');
                $obj = DiUser::model()->findByAttributes(array('login_ref_id' => $this->_id));
                $subId = $obj->di_user_id;

                break;
            case '4':
                $obj = Admin::model()->findByAttributes(array('login_ref_id' => $this->_id));
                $subId = $obj->admin_id;
                break;
            //@todo add alumni.
            case '5':
                $obj = Student::model()->findByAttributes(array('login_ref_id' => $this->_id));
                $subId = $obj->user_id;
                break;
            case '6':
                Yii::import('application.modules.vendor.models.*');
                $subId = 0;
                $obj = VendorContact::model()->findByAttributes(array('login_ref_id' => $this->_id));
                if($obj){
                    $subId = $obj->vendor_contact_id;
                    $vendorType = $obj->vendorRef->vendor_type;
                    $this->setState('isVendor', $vendorType);
                    $this->setState('vendor_name', $obj->vendorRef->name);
                    $this->setState('vendor_id', $obj->vendorRef->vendor_id);
                    $this->_setupVendorPreferences($obj->vendorRef->vendor_id, $vendorType);
                }else{
                    $obj = VendorCentreContact::model()->findByAttributes(array('login_ref_id' => $this->_id));
                    $subId = $obj->vendor_centre_contact_id;
                    $this->setState('isVendor', 'CenterUser');
                    $this->setState('vendor_name', $obj->vendorCentreRef->vendorRef->name);
                    $this->setState('vendor_id', $obj->vendorCentreRef->vendorRef->vendor_id);
                }
                break;
            case '7':
                $obj = FranchiseInfo::model()->findByAttributes(array('login_ref_id' => $this->_id));
                if($obj){
                $this->setState('franchise_name', $obj->first_name);
                $subId = $obj->franchise_info_id;
                }
                break;
            case '8':
                Yii::import('application.modules.ctp.models.*');
                $obj = CtpInfo::model()->findByAttributes(array('login_ref_id'=>$this->_id,'is_active'=>'Y')); 
                    //FranchiseInfo::model()->findByAttributes(array('login_ref_id' => $this->_id));
                if($obj){
                $this->setState('ctp_name', $obj->first_name);
                $subId = $obj->ctp_info_id;
                }
                break;
        }

        return $subId;
    }

    private function registerSession()
    {
        $oUser = $this->user;
		
        switch ($oUser->user_type_ref_id) {

            case '1' : // student
                $oStudent = $oUser->tblUserMasters[0];
                if ($oStudent === null) {					
                    Yii::app()->session->destroy();
                    $this->errorCode = self::ERROR_UNKNOWN_IDENTITY;
                    return;
                }
			 
                //UniVisitPreStudentsInvited::model()->updateAll(array('student_ref_id'=> $oStudent->user_id),                    'student_email="'.$this->username.'"');
                //UniVisitPostStudentsInvited::model()->updateAll(array('student_ref_id'=> $oStudent->user_id),                    'student_email="'.$this->username.'"');

				if(!empty(Yii::app()->session['scholarshipIds']))
				{
					$scholarshipIds = explode(',',Yii::app()->session['scholarshipIds']);				
					foreach($scholarshipIds as $key => $value){
					   UserScholarship::addUserScholarshipList($oStudent->user_id,$value,$oStudent->login_ref_id);
					}					
				}				
				unset(Yii::app()->session['scholarshipIds']);

                $aStudentInfo = array(
                    'UserId' => $oStudent->user_id,
                    'UserFullName' => $oStudent->first_name . ' ' . $oStudent->last_name,
                    //'UserType' => $oStudent->user_type,
                    'UserType' => $oStudent->membership_ref_id,
                    'UserEmail' => $oUser->username,
                    'fldUserEmail' => $oUser->username,
                    'institute_id' => '',
                    'institute_logo' => '',
                    'institute_name' => '',
                    'institute_profile_url' => '',
                    'PresentClass' => $oStudent->present_class,
                    'institute_business_model' => '',
                    'institute_subdomain_name' => '',
                    'hasCSSAccess' => '',
                    'isConfirmedEmail' => $this->user->is_email_confirmed,
                );

                $oUrl = LookupUrl::model()->findByPk($oStudent->redirect_url_ref_id);
                if ($oStudent->membership_ref_id == 1 || $oStudent->membership_ref_id == 3) {
                    $sReturnUrl = Yii::app()->params['cbasepath'] . $oUrl->url;

                    /*
                    if($this->user->is_email_confirmed == 0 && $oStudent->membership_ref_id == 1 && empty(Yii::app()->session['signupProcess'])){
                       $sReturnUrl = Yii::app()->params['cbasepath'] . '/app/dashboard';
                    }
                    */

                } else {						
                    $Sql = "SELECT SI.inst_id, SI.inst_logo, SI.inst_name,SI.css_access,
                            SI.inst_slug_name,SI.business_model,SI.subdomain_slug_name,
                            SS.is_invitation_accepted FROM tbl_si_students SS
                            LEFT JOIN tbl_si_di SI ON SI.inst_id = SS.inst_ref_id
                            WHERE SS.user_ref_id =:user_ref_id";

                    $Cmd = Yii::app()->db->createCommand($Sql);
                    $Cmd->bindParam(":user_ref_id", $aStudentInfo['UserId'], PDO::PARAM_INT);
                    $Res = $Cmd->queryRow();					
                    if ($Res) {						
                        $aInstituteInfo = array(
                            'institute_id' => $Res['inst_id'],
                            'institute_logo' => $Res['inst_logo'],
                            'institute_name' => $Res['inst_name'],
                            'institute_profile_url' => $Res['inst_id'],
                            'institute_business_model' => $Res['business_model'],
                            'institute_subdomain_name' => $Res['subdomain_slug_name'],
                            'hasCSSAccess' => $Res['css_access'],
                        );

                        $aStudentInfo = CMap::mergeArray($aStudentInfo, $aInstituteInfo);

                        if ($Res['css_access']) {

                            $asPartnersSlug = array(
                                'instituteID' => $Res['inst_id'],
                                'instituteLogo' => $Res['inst_logo'],
                                'subDomainSlugName' => $Res['subdomain_slug_name'],
                                'accountType' => $Res['business_model'],
                                'instituteName' => $Res['inst_name'],
                                'hasCSSAccess' => $Res['css_access']
                            );
                            Yii::app()->session->add('sPartnersSlug', serialize($asPartnersSlug));
                            $sProtocol = CommonUtils::getProtocol();
                            $sSubDomain = $Res['subdomain_slug_name'];
                            $sMainDomain = $this->getMainDomainName();
                            $this->setState('slugname', $sSubDomain);
                            //$sReturnUrl = $sProtocol . $sSubDomain . '.' . $sMainDomain . '/app/profile';
                            if(!UNI_LOCAL)
                                $sReturnUrl = $sProtocol . $sSubDomain . '.' . $sMainDomain . $oUrl->url;
                            else
                                $sReturnUrl = $sProtocol . $sMainDomain. $oUrl->url;

                        } else {
                           // $sReturnUrl = Yii::app()->params['cbasepath'] . '/app/profile';
                            $sReturnUrl = Yii::app()->params['cbasepath'] . $oUrl->url;
                        }
                    } else {							
                        //$sReturnUrl = Yii::app()->params['cbasepath'] . '/user/dashboard.php';
						$sReturnUrl = Yii::app()->params['cbasepath'] . '/app/myProfile/thankyou';
                    }
				    /* check user membership type
                        if 1 -b2c user, get the profile redirect url
                        if 2 -si user, check css access for the si and register sPartnerSlug session
                        and then redirect to profile page with partner subdomain
                        else redirect to normal profile page WITH OUT partner subdomain
                    */
                }
				
				

                Yii::app()->session->add('sUserUnivariety', serialize($aStudentInfo));

				$this->setReturnUrl($sReturnUrl);
				
				/*$redirectSessionURL = Yii::app()->session->get('redirectURL');
				///URL is present in session, will redirect to that url
				if($redirectSessionURL){
				   $this->setReturnUrl($redirectSessionURL);
				}else{				
                   $this->setReturnUrl($sReturnUrl);
				}*/
                break;

            case '2' : // Si

                $Sql = "SELECT si.inst_id,si.inst_email, si.inst_password, si.inst_name,
                        si.inst_slug_name, si.inst_type,inst_username, si.is_active,
                        si.is_confirm,si.inst_logo,si.css_access,si.subdomain_slug_name,
                        si.business_model,lm.is_active AS loginactive,
                        ta.is_active AS adminactive FROM tbl_si_di si,tbl_admin ta,
                        login_master lm WHERE si.inst_id = ta.si_ref_id AND
                        lm.login_id = ta.login_ref_id AND ta.login_ref_id =:login_id";

                $Cmd = Yii::app()->db->createCommand($Sql);
                $Cmd->bindParam(":login_id", $this->_id, PDO::PARAM_INT);
                $Res = $Cmd->queryRow();

                if ($Res) {

                    $aInstituteInfo = array(
                        'InstId' => $Res['inst_id'],
                        'InstEmail' => $Res['inst_email'],
                        'InstName' => $Res['inst_name'],
                        'InstType' => $Res['inst_type'],
                        'InstUserName' => $Res['inst_username'],
                        'InstLogo' => $Res['inst_logo'],
                        'hasCSSAccess' => $Res['css_access'],
                        'SubDomainName' => $Res['subdomain_slug_name'],
                        'BusinessModel' => $Res['business_model'],
                        'InstProfileURL' => Yii::app()->params['cbasepath'] . '/institutes/' . $Res['inst_slug_name'] . '/' . $Res['inst_id'],
                        //'InstProfileURL'=> getInstituteProfileLink($Res['inst_id'], $Res['inst_slug_name']),

                    );

                    $is_active = $Res["is_active"];
                    $is_confirm = $Res["is_confirm"];
                    $is_loginmaster_active = $Res["loginactive"];
                    $is_tbladmin_active = $Res["adminactive"];

                    if ($is_active == 'Y' &&
                        $is_confirm == 'Y' &&
                        $is_loginmaster_active == true &&
                        $is_tbladmin_active == 'Y'
                    ) {

                        if ($Res['css_access']) {

                            $asPartnersSlug = array(
                                'instituteID' => $Res['inst_id'],
                                'instituteLogo' => $Res['inst_logo'],
                                'subDomainSlugName' => $Res['subdomain_slug_name'],
                                'accountType' => $Res['business_model'],
                                'instituteName' => $Res['inst_name'],
                                'hasCSSAccess' => $Res['css_access']
                            );
                            Yii::app()->session->add('sPartnersSlug', serialize($asPartnersSlug));

                            $sProtocol = CommonUtils::getProtocol();
                            $sSubDomain = $Res['subdomain_slug_name'];
                            $sMainDomain = $this->getMainDomainName();
                            $sReturnUrl = $sProtocol . $sSubDomain . '.' . $sMainDomain . '/app/schoolDashboard/partnerDashboard';

                        } else
                            $sReturnUrl = Yii::app()->params['cbasepath'] . '/institutes/dashboard.php';

                        /* check css access and register sPartnerSlug and get the slugname
                            redirect to
                            slugname.unvariety.com/app/schoolDashboard/partnerDashboard
                            else
                            unvariety.com/institutes/dashboard.php
                         *
                         * */
                        Yii::app()->session->add('sInstituteUnivariety', serialize($aInstituteInfo));
                        $this->setReturnUrl($sReturnUrl);
                    } else {
                        Yii::app()->session->destroy();
                        $this->errorCode = self::ERROR_UNKNOWN_IDENTITY;
                        return;
                    }
                } else {

                    Yii::app()->session->destroy();
                    $this->errorCode = self::ERROR_UNKNOWN_IDENTITY;
                    return;
                }

                break;

            case '3': // DI

                $oDi = $oUser->diUsers1[0];
                $diRef = $oDi->diRef;
                if($diRef->is_active != '1'){
                    $this->errorCode = self::ERROR_ACCOUNT_INACTIVE;
                    return;
                }

                $this->setState('di_type', $oDi->user_type);
                $this->setState('di_id', $oDi->di_ref_id);
                $this->setState('isGuestDi', $diRef->di_type_ref_id == '1' ? true : false);
                $this->setState('di_currency_code', $diRef->currencyRef->html_entity);
                $uniRef = $diRef->uniRef;
                $this->setState('di_uni_name', $uniRef->uni_name);
                $this->setState('di_uni_id', $uniRef->uni_id);
                $this->setState('di_uni_country_id', $uniRef->country_ref_id);

                // check eligibility for sending email campaigns
                Yii::import('application.modules.di.components.DiAccount');
                $diAcc           = new DiAccount;
                $diAcc->diID     = $oDi->di_ref_id;
                $activeProductForEC  = $diAcc->getActiveDiProductForEmailCampaign();
                $emailCampaignSettings = DiEmailCampaignSettings::model()->find("di_ref_id ='".$oDi->di_ref_id."'");
                $this->setState('di_has_email_campaign_settings', $emailCampaignSettings && $activeProductForEC ? true : false);

                $this->setReturnUrl(
                    Yii::app()->params['cbasepath'] . '/app/di/dashboard'
                );

                break;
            case '6': // TE

                $vendorType = $this->getState('isVendor');
                if($vendorType == 'CenterUser')
                    $redirectUrl = Yii::app()->params['cbasepath'] . '/app/te';
                else
                    $redirectUrl = Yii::app()->params['cbasepath'] . '/app/expert/acquisition/landing';

                $this->setReturnUrl($redirectUrl);

                break;
            case '7': // Franchise
                $redirectUrl = Yii::app()->params['cbasepath'] . '/app/strategicPartner/dashboard';
                $this->setReturnUrl($redirectUrl);

                break;
            case '8': // CTp
                $redirectUrl = Yii::app()->params['cbasepath'] . '/app/ctp';
                $this->setReturnUrl($redirectUrl);

                break;

            case '4': // Advisor

                $oAdmin = Admin::model()->findByAttributes(array(
                    'login_ref_id' => $this->_id,
                    'is_active' => 1
               ));

                if ($oAdmin === null) {
                    Yii::app()->session->destroy();
                    $this->errorCode = self::ERROR_UNKNOWN_IDENTITY;
                    return;
                }

                $role_name = Yii::app()->db->createCommand()
                        ->select('TblAdminRole.role_name')
                        ->from(TblAdminRole::model()->tableSchema->name.' TblAdminRole')
                        ->join(TblAdmin::model()->tableSchema->name.' TblAdmin', 'TblAdmin.role_type_id = TblAdminRole.role_id AND TblAdmin.login_ref_id = '.$oAdmin->login_ref_id)
                        ->queryScalar();
                
                $aAdminInfo = array(
                    'adminId' => $oAdmin->admin_id,
                    'adminName' => $oAdmin->admin_name,
                    'adminEmail' => $oAdmin->admin_email,
                    'recPaging' => $oAdmin->records_per_page,
                    'role_type_id' => $oAdmin->role_type_id,
                    'roles' => $oAdmin->roles,
                    'role_name' => $role_name,
                    'adminLoginRefId' => $oAdmin->login_ref_id,
                );
                
                Yii::app()->session->add('admin_role_type_id', $oAdmin->role_type_id);
                Yii::app()->session->add('admin_role_name', $role_name);
                Yii::app()->session->add('sAdminUnivarietyContent', serialize($aAdminInfo));
				
				if($oAdmin->role_type_id==17) {
                    //exteral advisor
					$_SESSION['extadv']=1; // It states that logged in user is external advisor.
					$this->setReturnUrl(
						Yii::app()->params['cbasepath'] . '/app/extadvdashboard'
					);
				}elseif($oAdmin->role_type_id==19) {
                    //face-to-face counsellor
                    $this->setReturnUrl(
                        Yii::app()->params['cbasepath'] . '/app/fcfcounsellor'
                    );
                }
				else{
					$_SESSION['extadv']=0; // It states that logged in user is external advisor.
					$this->setReturnUrl(
						Yii::app()->params['cbasepath'] . '/mainadmin/admin_home.php'
					);
				}
                break;
        }
        // echo CJSON::encode($user); exit;
    }

    private function getMainDomainName()
    {
        $domainName = Yii::app()->request->getServerName();
        if(!UNI_LOCAL) {
            $aDomain = explode(".", $domainName);
            if (count($aDomain) > 2) {
                return $aDomain[1] . "." . $aDomain[2];
            }
            return $domainName;
        }
        else {
            return $domainName;
        }
    }


    private function fixWWW($sUrl = ''){

        if (preg_match('/www\./', $sUrl))
            $sUrl = str_replace('://', '://www.', str_replace('www.', '', $sUrl));

        return $sUrl;
    }

    private function setReturnUrl($sUrl = '') {

        //$sRUrl = Yii::app()->user->returnUrl;
        $subID = $this->getSubId();
        $sUrl = str_replace('{USER_ID}',$subID,$sUrl);

        if($sessionURL = Yii::app()->session->get('redirectURL')){
            $this->setState('redirectUrl', $this->fixWWW($sessionURL));
            Yii::app()->session->add('redirectURL', null);
        }else
            $this->setState('redirectUrl', $this->fixWWW($sUrl));
    }

    private function _setupVendorPreferences($vendorID = 0, $vendorType=''){

        $this->setState('vendorCountries', array());
        $this->setState('vendorDepartments', array());
        $this->setState('vendorUniversities', array());
        $this->setState('vendorTests', array());

        $this->setState('vendorCountryNames', array());
        $this->setState('vendorDepartmentNames', array());
        $this->setState('vendorUniversityNames', array());
        $this->setState('vendorTestNames', array());

        if($vendorType == 'Institute'){

            $Sql = "SELECT
            GROUP_CONCAT(DISTINCT vcct.entrance_ref_id) AS tests,
            GROUP_CONCAT(DISTINCT ee.entrance_short_name) AS test_names FROM vendor v
            JOIN vendor_centre vc ON vc.vendor_ref_id = v.vendor_id
            JOIN vendor_centre_course vcc ON vcc.vendor_centre_ref_id = vc.vendor_centre_id
            JOIN vendor_centre_course_test vcct ON vcct.vendor_centre_course_ref_id = vcc.vendor_centre_course_id
            JOIN entrance_exam ee ON ee.entrance_id = vcct.entrance_ref_id
            WHERE v.vendor_id ='".$vendorID."'";
            $cmdRes = Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
            if($cmdRes && $cmdRes->tests){
                $this->setState('vendorTests', explode(',', $cmdRes->tests));
                $this->setState('vendorTestNames', explode(',', $cmdRes->test_names));
            }


        }elseif($vendorType == 'TestExpert'){
            $Sql = "SELECT
            GROUP_CONCAT(DISTINCT vet.entrance_ref_id) AS tests,
            GROUP_CONCAT(DISTINCT ee.entrance_short_name) AS test_names FROM vendor_contact vc
            JOIN vendor_expertise_test vet ON vet.vendor_contact_ref_id = vc.vendor_contact_id
            JOIN entrance_exam ee ON ee.entrance_id = vet.entrance_ref_id
            WHERE vc.login_ref_id='".$this->_id."'";
            $cmdRes = Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
            if($cmdRes && $cmdRes->tests){
                $this->setState('vendorTests', explode(',', $cmdRes->tests));
                $this->setState('vendorTestNames', explode(',', $cmdRes->test_names));
            }

        }elseif($vendorType == 'CounsellorExpert'){

            $Sql = "SELECT
            GROUP_CONCAT(DISTINCT vec.country_ref_id) AS countries,
            GROUP_CONCAT(DISTINCT tcm.country_name) AS country_names FROM vendor_contact vc
            JOIN vendor_expertise_country vec ON vec.vendor_contact_ref_id = vc.vendor_contact_id
            JOIN tbl_country_master tcm ON tcm.country_id = vec.country_ref_id
            WHERE vc.login_ref_id='".$this->_id."'";
            $cmdRes = Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
            if($cmdRes && $cmdRes->countries){
                $this->setState('vendorCountries', explode(',', $cmdRes->countries));
                $this->setState('vendorCountryNames', explode(',', $cmdRes->country_names));
            }

            $Sql = "SELECT
            GROUP_CONCAT(DISTINCT ved.main_dept_ref_id) AS departments,
            GROUP_CONCAT(DISTINCT ld.department_name) AS department_names FROM vendor_contact vc
            JOIN vendor_expertise_department ved ON ved.vendor_contact_ref_id = vc.vendor_contact_id
            JOIN lookup_department ld ON ld.department_id = ved.main_dept_ref_id
            WHERE vc.login_ref_id='".$this->_id."'";
            $cmdRes = Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
            if($cmdRes && $cmdRes->departments){
                $this->setState('vendorDepartments', explode(',', $cmdRes->departments));
                $this->setState('vendorDepartmentNames', explode(',', $cmdRes->department_names));
            }

            $Sql = "SELECT
            GROUP_CONCAT(DISTINCT veu.uni_ref_id) AS universities,
            GROUP_CONCAT(DISTINCT tum.uni_name) AS university_names FROM vendor_contact vc
            JOIN vendor_expertise_university veu ON veu.vendor_contact_ref_id = vc.vendor_contact_id
            JOIN tbl_university_master tum ON tum.uni_id = veu.uni_ref_id
            WHERE vc.login_ref_id='".$this->_id."'";
            $cmdRes = Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
            if($cmdRes && $cmdRes->universities){
                $this->setState('vendorUniversities', explode(',', $cmdRes->universities));
                $this->setState('vendorUniversityNames', explode(',', $cmdRes->university_names));
            }
            $VExams = EntranceExam::GetEntranceExams();
            $VExams = count($VExams) ? array_keys(call_user_func_array('array_replace', $VExams)) : array();
            $this->setState('vendorTests', $VExams);
        }
    }
}
