<?php

class Conditions extends CComponent {

    public $userId = null;

    public function validateDepartmentOptions() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id  = '".$this->userId."' AND not_sure = 1";
        $res = StudentPreferredDepartment::model()->find($criteria);
        if ($res) {
            return 1;
        }

        //Check whether we have user details or not
        $user = TblUserMaster::model()->findByPk($this->userId);
        if (!$user->user_id) {
            return 0;
        }

        $prefCourses = $user->getPreferredCourses();
        $i = 0;
        $pref1 = 0;
        foreach ($prefCourses as $course) {
            if ($i == 0 && $course['main_dept_ref_id']) {
                $pref1 = $course['main_dept_ref_id'];
                $i++;
                continue;
            }
        }

        return ($pref1 != 0) ? 1 : 0;
    }

    public function validateDepartment() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id  = '".$this->userId."' AND not_sure = 1";
        $res = StudentPreferredDepartment::model()->find($criteria);
        if ($res) {
            return 1;
        }

        //Check whether we have user details or not
        $user = TblUserMaster::model()->findByPk($this->userId);
        if (!$user->user_id) {
            return 0;
        }

        $pref2 = 0;
        $prefCourses = $user->getPreferredCourses();
        $i = 1;
        foreach ($prefCourses as $course) {
            if ($i == 1 && $course['main_dept_ref_id']) {
                $pref1 = $course['main_dept_ref_id'];
                $i++;
                continue;
            }
            if ($i == 2 && $course['main_dept_ref_id']) {
                $pref2 = $course['main_dept_ref_id'];
                $i++;
                continue;
            }
        }

        $criteria = new CDbCriteria;
        $criteria->select = 'score';
        $criteria->condition = " dept_ref_id = $pref1 AND dept_pref_2 = $pref2 ";
        $result = DepartmentValidation::model()->find($criteria);
        return $result->score;
    }

    public function validateProfileCompletion() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $profilePercentage = CommonUtils::calculateCriticalPercentage($this->userId);
        return $profilePercentage >= 50 ? 1 : 0;
    }

    public function board10() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $criteria = new CDbCriteria;
        $criteria->select = 'board_ref_id';
        $criteria->condition = " user_ref_id = ".$this->userId." AND class_level = '10' ";
        $result = StudentEducation::model()->find($criteria);

        return $result->board_ref_id ? 1 : 0;
    }

    public function board12() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $criteria = new CDbCriteria;
        $criteria->select = 'board_ref_id';
        $criteria->condition = " user_ref_id = ".$this->userId." AND class_level = '12' ";
        $result = StudentEducation::model()->find($criteria);

        return $result->board_ref_id ? 1 : 0;
    }

    public function marks10Given() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $criteria = new CDbCriteria;
        $criteria->select = 'overall_marks, student_education_id';
        $criteria->condition = " user_ref_id = ".$this->userId." AND class_level = '10' ";
        $result = StudentEducation::model()->find($criteria);

        return $result->student_education_id ? 1 : 0;
    }

    public function marks12Given() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $criteria = new CDbCriteria;
        $criteria->select = 'overall_marks, student_education_id';
        $criteria->condition = " user_ref_id = ".$this->userId." AND class_level = '12' ";
        $result = StudentEducation::model()->find($criteria);

        return $result->student_education_id ? 1 : 0;
    }

    public function validateNumber() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $phone = StudentContactNumber::model()->find('contact_type_ref_id = 1 AND is_primary = 1 AND user_ref_id = '.$this->userId);
        if ($phone->number) { return 1;
            if ($phone->country_code == 91) { /*
                $res = file_get_contents('http://www.bmobile.in/'.$phone->number);

                $res_arr = explode('<table class="table table-hover table-condensed "><tbody>', $res);
                $res_arr1 = explode('</tbdy>', $res_arr[1]);

                $count = 0;
                $count = substr_count($res_arr1[0], $phone->number);*/

                return ($phone->number[0] > 6) ? 1 : 0;
            } else {
                return 1;
            }
        } else {
            return 0;
        }
    }
}