<?php

class ValidateStudent extends CComponent {

    public $userId = null;

    public function validateProfileAfterSignup() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        //Check whether we have user details or not
        $user = TblUserMaster::model()->findByPk($this->userId);
        if (!$user->user_id) {
            return 0;
        }
        /*
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id  = '".$this->userId."' AND not_sure = 1";
        $res = StudentPreferredDepartment::model()->find($criteria);
        if ($res->preferred_department_id) {
            return 0;
        }

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id  = '".$this->userId."' AND not_sure = 1";
        $res = StudentPreferredCountry::model()->find($criteria);
        if ($res->preferred_country_id) {
            return 0;
        }
        */
        $conditions_obj = new Conditions();
        $conditions_obj->userId = $this->userId;

        $passoutYear_obj = new ValidatePassoutYear();
        $passoutYear_obj->userId = $this->userId;

        $marks_obj = new ValidateMarks();
        $marks_obj->userId = $this->userId;

        $country_obj = new ValidateCountry();
        $country_obj->userId = $this->userId;

        $sum = 0;

        $profile_validate = ProfileValidationScore::model()->findByAttributes(array('user_ref_id'=>$this->userId));
        if ($profile_validate->profile_validation_score_id) {
            $profile_validate_obj = ProfileValidationScore::model()->findByPk($profile_validate->profile_validation_score_id);
        } else {
            $profile_validate_obj = new ProfileValidationScore();
        }
        $profile_validate_obj->user_ref_id = $this->userId;
        $sum += $profile_validate_obj->profile_score = $conditions_obj->validateProfileCompletion();
        $sum += $profile_validate_obj->passout_year = $passoutYear_obj->validateClass();
        $sum += $profile_validate_obj->board_10 = $conditions_obj->board10();
        $sum += $profile_validate_obj->board_12 = $conditions_obj->board12();
        $sum += $profile_validate_obj->marks_10 = $conditions_obj->marks10Given();
        $sum += $profile_validate_obj->marks_12 = $conditions_obj->marks12Given();
        if (($profile_validate_obj->marks_12 == 1) && ($profile_validate_obj->marks_10 == 1)) {
            $sum += $profile_validate_obj->marks_100 = $marks_obj->ValidateMarks('equals100');
            $sum += $profile_validate_obj->marks_above_95 = $marks_obj->ValidateMarks('above95');
            $sum += $profile_validate_obj->marks_diff = $marks_obj->ValidateMarks('diff');
        }
        $sum += $profile_validate_obj->subject_marks_10_100 = $marks_obj->validateSubjectMarks10();
        $sum += $profile_validate_obj->subject_marks_12_100 = $marks_obj->validateSubjectMarks12();
        $sum += $profile_validate_obj->pref_country = $country_obj->validateCountryOptions();
        if ($profile_validate_obj->pref_country == 1) {
            $sum += $profile_validate_obj->pref_country_score = $country_obj->validateCountry();
        } else {
            $sum += $profile_validate_obj->pref_country_score = 0;
        }
        $sum += $profile_validate_obj->pref_dept = $conditions_obj->validateDepartmentOptions();
        if ($profile_validate_obj->pref_dept == 1) {
            $sum += $profile_validate_obj->pref_dept_score = $conditions_obj->validateDepartment();
        } else {
            $sum += $profile_validate_obj->pref_dept_score = 0;
        }

        if (($profile_validate_obj->board_10 == 0) && (($profile_validate_obj->marks_10 == 1))) {
            $sum += $profile_validate_obj->board_10 = $conditions_obj->board10();
        }

        if (($profile_validate_obj->board_12 == 0) && (($profile_validate_obj->marks_12 == 1))) {
            $sum += $profile_validate_obj->board_12 = $conditions_obj->board12();
        }

        if (($profile_validate_obj->marks_12 == 1) && ($profile_validate_obj->marks_10 == 1) && ($profile_validate_obj->board_12 == 0) && (($profile_validate_obj->marks_12 == 1))) {
            $sum += $profile_validate_obj->marks_100 = $marks_obj->ValidateMarks('equals100');
            $sum += $profile_validate_obj->marks_above_95 = $marks_obj->ValidateMarks('above95');
            $sum += $profile_validate_obj->marks_diff = $marks_obj->ValidateMarks('diff');
        }

        $sum += $profile_validate_obj->contact_number = $conditions_obj->validateNumber();
        $profile_validate_obj->added_on = date('Y-m-d H:i:s');
        $profile_validate_obj->save(false);

        $lm_obj = LoginMaster::model()->findByPk($user->login_ref_id);
        if ($sum == 16) {
            if ($lm_obj->is_valid != 1 && ($lm_obj->is_email_confirmed == 1)) {
                $lm_obj->is_email_confirmed = 1;
                $lm_obj->is_class_status_confirmed = 1;
                $lm_obj->is_preference_confirmed = 1;
                $lm_obj->is_valid = 1;
                $lm_obj->validated_on = date('Y-m-d H:i:s');
                $lm_obj->save(false);
            }
        }

        $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$this->userId));
        if ($profile_verify->profile_verification_score_id) {
            $profile_verify_obj = ProfileVerificationScore::model()->findByPk($profile_verify->profile_verification_score_id);
        } else {
            $profile_verify_obj = new ProfileVerificationScore();
        }
        $profile_verify_obj->user_ref_id = $this->userId;

        if ($profile_validate_obj->profile_score == 1) {
            $profile_verify_obj->profile_score = 1;
            $profile_verify_obj->profile_score_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->passout_year == 1) {
            $profile_verify_obj->passout_year = 1;
            $profile_verify_obj->passout_year_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->board_10 == 1) {
            $profile_verify_obj->board_10 = 1;
            $profile_verify_obj->board_10_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->board_12 == 1) {
            $profile_verify_obj->board_12 = 1;
            $profile_verify_obj->board_12_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->marks_10 == 1) {
            $profile_verify_obj->marks_10 = 1;
            $profile_verify_obj->marks_10_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->marks_12 == 1) {
            $profile_verify_obj->marks_12 = 1;
            $profile_verify_obj->marks_12_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->marks_100 == 1) {
            $profile_verify_obj->marks_100 = 1;
            $profile_verify_obj->marks_100_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->marks_above_95 == 1) {
            $profile_verify_obj->marks_above_95 = 1;
            $profile_verify_obj->marks_above_95_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->marks_diff == 1) {
            $profile_verify_obj->marks_diff = 1;
            $profile_verify_obj->marks_diff_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->subject_marks_10_100 == 1) {
            $profile_verify_obj->subject_marks_10_100 = 1;
            $profile_verify_obj->subject_marks_10_100_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->subject_marks_12_100 == 1) {
            $profile_verify_obj->subject_marks_12_100 = 1;
            $profile_verify_obj->subject_marks_12_100_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->pref_country == 1) {
            $profile_verify_obj->pref_country = 1;
            $profile_verify_obj->pref_country_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->pref_country_score == 1) {
            $profile_verify_obj->pref_country_score = 1;
            $profile_verify_obj->pref_country_score_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->pref_dept == 1) {
            $profile_verify_obj->pref_dept = 1;
            $profile_verify_obj->pref_dept_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->pref_dept_score == 1) {
            $profile_verify_obj->pref_dept_score = 1;
            $profile_verify_obj->pref_dept_score_date = date('Y-m-d H:i:s');
        }

        if ($profile_validate_obj->contact_number == 1) {
            $profile_verify_obj->contact_number = 1;
            $profile_verify_obj->contact_number_date = date('Y-m-d H:i:s');
        }
        $profile_verify_obj->save(false);


    }

    public function validate_after_confirmation ($verify_id, $user) {
        $verify_score = ProfileVerificationScore::model()->findByPk($verify_id);

        $conditions_obj = new Conditions();
        $conditions_obj->userId = $user->user_id;
        if ($verify_score->profile_score == 0 && $verify_score->profile_verification_score_id) {
			$verify_score->profile_score = $conditions_obj->validateProfileCompletion();
			$verify_score->profile_score_date = date('Y-m-d H:i:s');
			$verify_score->save(false);
		}

        $login_det = LoginMaster::model()->findByPk($user->login_ref_id);

        $sum = 0;
        $sum += (int)$verify_score->profile_score;
        $sum += (int)$verify_score->passout_year;
        $sum += (int)$verify_score->board_10;
        $sum += (int)$verify_score->board_12;
        $sum += (int)$verify_score->marks_10;
        $sum += (int)$verify_score->marks_12;
        $sum += (int)$verify_score->marks_100;
        $sum += (int)$verify_score->marks_above_95;
        $sum += (int)$verify_score->marks_diff;
        $sum += (int)$verify_score->subject_marks_10_100;
        $sum += (int)$verify_score->subject_marks_12_100;
        $sum += (int)$verify_score->pref_country;
        $sum += (int)$verify_score->pref_country_score;
        $sum += (int)$verify_score->pref_dept;
        $sum += (int)$verify_score->pref_dept_score;
        $sum += (int)$verify_score->contact_number;

        if (($sum == 16) && ($login_det->is_email_confirmed == 1)) {
            $lm_obj = LoginMaster::model()->findByPk($user->login_ref_id);

            $lm_obj->is_email_confirmed = 1;
            $lm_obj->is_class_status_confirmed = 1;
            $lm_obj->is_preference_confirmed = 1;
            $lm_obj->is_valid = 1;
            $lm_obj->validated_on = date('Y-m-d H:i:s');
            $lm_obj->save(false);

            if (in_array($_GET['type'], array('d2', 'd5', 'd7'))) {
                $t = '';
                if ($_GET['type'] == 'd2') {
                    $t = 'DAY2';
                } elseif ($_GET['type'] == 'd5') {
                    $t = 'DAY5';
                } elseif ($_GET['type'] == 'd7') {
                    $t = 'DAY7';
                }
                if ($t != '') {
                    $validationTracker = StudentValidationTracker::model()->findByAttributes(array('user_ref_id'=>$user->user_id, 'email_type'=>$t));
                    if ($validationTracker) {
                        $validationTracker->profile_confirm_date = date('Y-m-d H:i:s');
                        $validationTracker->save(false);
                    }
                }
            }

        }
    }


}