<?php

class CareerController extends Controller
{
    public $layout = '//layouts/new_grid_inner';
    public $careersList = array();
    public $career_count = 0;

        // Add code for RBAC
        public function filters() {
            return array(
                'rights + accessControl',
            );
        }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'StudentInterests', 'GetInterests', 'GetMatchingCareer'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update', 'landing'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
        
    public function actionIndex()
    {       
        $this->breadcrumbs=array(
            'Home'=>array('/home'),
            'Careers',
        );

        $this->canonicalUrl = 'https://www.univariety.com/app/career';
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        $this->metaDesc = 'Looking for Career oriented Courses after 12th & Intermediate, Science, Business Management at Univariety. Explore here for the list of career choices and the place for finding right career guidance and get help in suggesting top career options by our experienced career couselors.';
        $this->metaKeyword = 'careers options after 12th, career options after 12th science, career options after 12th commerce, career counseling, Career Guidance, best Career Options, best careers opportunities, Career Planning Advisor, Education Career, Choose Your Career, how to choose career, Career Development, career options in India, diploma courses, diploma programme, Career Oriented Courses';
        $this->setPageTitle('Career Oriented Courses After 12 & Intermediate - Univariety');
       
        //To get the department list
        $dept_sql="SELECT ld.department_id,ld.dept_alias AS department_name  FROM lookup_department AS ld
        INNER JOIN `lookup_career` AS lc ON lc.main_dept_ref_id=ld.department_id
        LEFT JOIN `career_country` cc ON cc.career_ref_id = lc.career_id 
         WHERE lc.is_active = 1 AND lc.is_career_page = 1 AND (cc.country_ref_id = '100' OR cc.country_ref_id IS NULL)
        GROUP BY ld.department_id ORDER BY ld.dept_alias ASC";
        $dept_temp_list=Yii::app()->db->createCommand($dept_sql)->queryAll();
        $dept_list=array();
        if(!empty($dept_temp_list))
        {
            foreach($dept_temp_list as $tlist){
                $dept_count=count(LookupCareer::getCareerListByIP(0,0,$tlist['department_id']));
                $dept_list[$tlist['department_id']]=$tlist['department_name']." (".$dept_count.")";
            }
        }
        $dept_count=count(LookupCareer::getCareerCount());
        $dept_list['NULL']="Others (".$dept_count.")";
        $departmentRefId=0;
        //Obtain the selected departmet data
        if($_POST['depthidden']){             
                $departmentRefId=Yii::app()->request->getParam('depthidden'); 
        } 
        
        $limit =5;
        $offset = 0;
        $limit = isset($_GET['limit']) ? $_GET['limit'] : $limit;
        $offset = isset($_GET['offset']) ? $_GET['offset'] : $offset;
        if(Yii::app()->request->getParam('deptvalues')){
            $dept_values=Yii::app()->request->getParam('deptvalues'); 
            $departmentRefId=implode(",",$dept_values);
        }
        
        if($departmentRefId==='NULL'){            
            $this->careersList = LookupCareer::getCareerListByIP($limit,$offset,'NULL');
            $this->career_count=count(LookupCareer::getCareerListByIP(0,0,'NULL'));  
        }
        else{
            $this->careersList = LookupCareer::getCareerListByIP($limit,$offset,$departmentRefId);
            $this->career_count=count(LookupCareer::getCareerListByIP(0,0,$departmentRefId));  
        }
        if(isset($_GET['offset']) && $_GET['limit']){
            $this->renderPartial('_careerList',array('dept_list'=>$dept_list,'departmentRefId'=>$departmentRefId));
        }
        else {     
        $this->render('careerIndex',array('dept_list'=>$dept_list,'departmentRefId'=>$departmentRefId)); }
    } 

	public function actionStudentInterests()
	{
		
		$interestIds = array();
		$showTab = 1;
		if(Yii::app()->user->hasFlash('CareerInterestIds')){
			$interestIds = Yii::app()->user->getFlash('CareerInterestIds');
			$showTab = 2;
		}
		$this->setPageTitle('Univariety : Search Careers Matching to Your Interests');
		$this->render('studentInterests', array(
			'interestIds' => $interestIds,
			'showTab' => $showTab,
		));
	}
	
	public function actionGetInterests()
	{
		//echo __METHOD__;
		if(isset($_REQUEST['interestId'])){
		$interestId = $_REQUEST['interestId'];
		$selectId = $_REQUEST['selectId'];
		$this->renderPartial('getInterests', array('interestId' => $interestId, 'selectId' => $selectId));
		}
	}
	
	public function actionGetMatchingCareer()
	{
		/*
		 if(has flash message,){
			getflashmessage.
		 }
		 
		 Yii::session
		*/
		$interestIds = $_POST['CareerInterest'];
		$this->renderPartial('getMatchingCareer', array('interestIds' => $interestIds));
	}
        
        public function actionGetThumbs($start, $end)
        {
            $this->careersList = LookupCareer::model()->findAll(array("condition" => "is_active = 1 AND is_career_page = 1 ORDER BY career_name LIMIT ".$start.",".$end));
            $this->renderPartial('_careerList');
        }        
	
    public function actionAjaxRedirecting() {
        $careerId = Yii::app()->request->getParam('career_id');
        $hashed = Yii::app()->request->getParam('hashed') ? Yii::app()->request->getParam('hashed') : 0;
        echo UniversityHelper::getCareerPageUrl($careerId, $hashed);
    }
    
    public function actionRedirecting() {
        $careerId = Yii::app()->request->getParam('career_id');
        $hashed = Yii::app()->request->getParam('hashed') ? Yii::app()->request->getParam('hashed') : 0;
        $this->redirect(UniversityHelper::getCareerPageUrl($careerId, $hashed));
    }
	
}