<?php

class DashboardController extends Controller {

    public $highlightBlueFields = false;
    public $redStripCount = 0;

    // Add code for RBAC
    public function filters() {
        return array(
            //'rights',
        );
    }

    public function init() {
        parent::init();
        Yii::app()->theme = 'uni_avada';
        $this->layout = "//layouts/inner_page";
        if (Yii::app()->session->itemAt('sInstituteUnivariety')) {
            //$sInstituteUnivariety = Yii::app()->session->itemAt('sInstituteUnivariety');
            $sInstituteUnivariety = unserialize(Yii::app()->session->get('sInstituteUnivariety'));
            $instEmail = $sInstituteUnivariety['InstEmail'];
            unset(Yii::app()->session['sUserUnivariety']);
            $loginObj = new LoginMaster;
            $loginObj->skipPassword = true;
            $loginObj->loginWithRedirect($instEmail, '', "/app/schoolDashboard/partnerDashboard");
        }
    }

    public function actionIndex() {

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $this->breadcrumbs = array(
            'Home' => array('/dashboard'),
            'Dashboard',
        );
        if(!Yii::app()->user->id) $this->redirect('/app/home');

        $tblRes = TblUserMaster::getStudentDetailsByLoginId(Yii::app()->user->id);
        if($tblRes['membership_ref_id'] > 1 && ($tblRes['present_class'] == "12" || $tblRes['present_class'] == "11") ) { // for new b2b students
            $this->redirect('/app/student/dashboard');
        } else if($tblRes['membership_ref_id'] == 1 && ($tblRes['present_class'] == "12" || $tblRes['present_class'] == "11" || $tblRes['present_class'] == '') ) {
            $this->redirect('/app/student/dashboard');
        }
        else {
            $this->studentDashboard($tblRes['present_class']);
        }
    }

    public function actionHideProfileInCompleteBar() {

        Yii::app()->session->add('hideProfileInCompleteness', true);
        $this->redirect('/');
    }

    public function actionSaveRedStipSession() {
        if (Yii::app()->session->itemAt('sUserUnivariety') && !Yii::app()->session->itemAt('sAdminUnivarietyContent') && !Yii::app()->session->itemAt('sInstituteUnivariety')) {
            $userSession = unserialize(Yii::app()->session->get('sUserUnivariety'));
            $this->highlightBlueFields = true;
            $userSession['highlightBlueFields'] = $this->highlightBlueFields;
            $userSession['showBlueNotification'] = true;
            Yii::app()->session->add('sUserUnivariety', serialize($userSession));
            $redirectUrl = TblUserProfCriticalCompletion::getUserMissedCriticalField(Yii::app()->user->sub_id, $this->action->id);
            if (Yii::app()->session->itemAt('studentProfileConfirmationId')) {
                if ($redirectUrl != '') {
                    $this->redirect($redirectUrl);
                } else {
                    $this->redirect('/app/student/profile/EditBasicInfo');
                }

                /* if($redirectUrl == ''){
                  echo '2423423';
                  //$this->redirect($redirectUrl);
                  }else{
                  //$this->redirect('/app/student/profile/EditBasicInfo');
                  echo $redirectUrl;
                  } */
            } else {
                echo $redirectUrl;
            }
            //echo $redirectUrl;
        }
    }

    public function studentDashboard($class) {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_signup";
        $this->render('tenth_NewDashboard');
    }

    public function studentB2BDashboard() {

        //$this->actionFeaturedUniBlock();
        $userId = Yii::app()->user->sub_id;

        $userName = TblUserMaster::getUserAttributeById($userId, 'first_name');

        //$offerDetails = DiUserEoi::getStudnetOfferDetail($userId, array('Ignore', 'Reject'), 10);
        //$offerCount = DiUserEoi::getStudnetOfferDetailCount($userId, array('Ignore', 'Reject'));
        //echo Yii::app()->user->sub_id;
        Yii::import('application.modules.offers.models.*');
        $receivedOffers = studentOffers::model()->getReceivedOffers();
        $offerDetails = $receivedOffers->getData();
        $offerCount   = count($offerDetails);

        //echo '<pre>'; print_r($offerDetails); exit;
        $profilePercentage = CommonUtils::calculateCriticalPercentage($userId);
        $userSession = unserialize(Yii::app()->session->get('sUserUnivariety'));

        if (!isset($userSession['redStripCount'])) {
            $this->redStripCount = 0;
        } else {
            $this->redStripCount = $userSession['redStripCount'] + 1;
        }

        if (Yii::app()->session->itemAt('sUserUnivariety') && !Yii::app()->session->itemAt('sAdminUnivarietyContent') && !Yii::app()->session->itemAt('sInstituteUnivariety')) {
            if (!isset($userSession['highlightBlueFields'])) {
                $userSession['highlightBlueFields'] = $this->highlightBlueFields;
            }
            $userSession['redStripCount'] = $this->redStripCount;
            Yii::app()->session->add('sUserUnivariety', serialize($userSession));
        }

        $this->render('b2bindex', array('profilePercentage' => $profilePercentage, 'offerDetails' => $offerDetails, 'offerCount' => $offerCount, 'userName' => $userName->first_name));
    }

    public function actionStaticsBlockData() {
        $userId = Yii::app()->user->sub_id;
        $objShortList = new ShortListEngine();
        $shortList = $objShortList->getShortList(array(SHORTLIST_MIGHTAPPLY, SHORTLIST_WILLAPPLY, SHORTLIST_APPLIED));

        $shortlistScholarship = UserScholarship::getShortlistScholarshipData($userId);

        $testData = UserEntranceExam::getUserExamsInfo($userId);

        $blockData = array();
        $blockData['collegeCount'] = count($shortList) ? count($shortList) : 0;
        $blockData['scholarshipCount'] = count($shortlistScholarship) ? count($shortlistScholarship) : 0;
        $blockData['testCount'] = count($testData) ? count($testData) : 0;
        echo json_encode($blockData);
    }

    public function actionMilestoneBlock() {
        $userId = Yii::app()->user->sub_id;

        $userData = TblUserMaster::getUserDetails($userId);
        $passoutYear = $userData->passout_year;
        $boardId = $userData->present_board_ref_id;

        $confirmedMilestoneDetails = UserMilestone::getUserConfirmedMilestoneDetails($userId);

        foreach ($confirmedMilestoneDetails as $confirmedMilestone) {
            $arr = array('css' => 'green-bg', 'text' => 'Completed on ' . date("F d, Y", strtotime($confirmedMilestone->added_on)));
            $milestoneArr["m" . $confirmedMilestone->milestone_id] = $arr;
        }

        $siMilestoneDetails = TblSiStudents::getStudentSiMilestoneDetail($userId, $boardId, $passoutYear);

        if ($siMilestoneDetails) {
            for ($i = 1; $i <= 6; $i++) {
                $milestonedate = '';
                if (!is_array($milestoneArr["m" . $i])) {
                    $milestonedate = $siMilestoneDetails["milestone" . $i . "_date"];

                    if ($milestonedate) {
                        if (strtotime(date("Y-m-d")) <= strtotime($milestonedate)) {
                            $milestoneArr["m" . $i] = array('css' => 'gray-bg', 'text' => 'Due on ' . date("F d, Y", strtotime($milestonedate)));
                        } else { // student missed deadline
                            $milestoneArr["m" . $i] = array('css' => 'red-bg', 'text' => 'Due on ' . date("F d, Y", strtotime($milestonedate)));
                        }
                    } else {
                        $milestoneArr["m" . $i] = array('css' => 'gray-bg', 'text' => 'No date decided yet');
                    }
                }
            }
        } else {
            for ($i = 1; $i <= 6; $i++) {
                if (!is_array($milestoneArr["m" . $i])) {
                    $milestoneArr["m" . $i] = array('css' => 'gray-bg', 'text' => 'No date decided yet');
                }
            }
        }

        echo json_encode($milestoneArr);
    }

    public function actionCalenderBlockData() {
        $userId = Yii::app()->user->sub_id;

        $dateList = array();
        $dateList = UniversityDateIntake::getUserRecentUniversityDate();

        $this->renderPartial('_calendar', array('dateList' => $dateList));
    }

    public function actionFeaturedUniBlock() {
        $userId = Yii::app()->user->sub_id;

        $featuredUnis = TblUniversityMaster::getUserFeaturedUni($userId);
        $this->renderPartial('_featured', array('featuredUnis' => $featuredUnis));
    }

    public function actionCreateIdealList() {
        $userId = Yii::app()->user->sub_id;
        UserIdealList::generateIdealList($userId);

        $idealListData = userIdealList::getIdealListCollegeCount($userId);

        $blockData['idealListCount'] = $idealListData['count'];
        echo json_encode($blockData);
    }

    public function actionOffersHelpPreview() {
        $this->renderPartial('_offersHelpPreview', array('featuredUnis' => $featuredUnis));
    }
}