<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseEmailRecipient');

class EmailRecipient extends BaseEmailRecipient
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  
  /*
   * Get email by its unique key
   */
  public function findByUniqueKey($k=false)
  {
  	$receipient = self::model()->find('unique_key=:key', array(':key' => $k));
  	
  	if($receipient)
  	{
  	  return $receipient;
  	}
  	else
  	{
  	  return false;	
  	}		
  	
  }
  
  public function findByEmail($email=false)
  {
  	$receipient = self::model()->find('to_email=:key', array(':key' => $email));
  	
  	if($receipient)
  	{
  	  return $receipient;
  	}
  	else
  	{
  	  return false;	
  	}		
  	
  }
  
  /*
   * This method returns all pending emails that are in queue.
   */
  public function getWaitingEmails($type='waiting')
  {
  	if('waiting' == $type)
  	{
          $criteria=new CDbCriteria();
          $criteria->condition = " `status` IN ('pending','ready') ";
          $criteria->order = " email_recipient_id ASC ";
          $criteria->limit = 100;
          return self::model()->findAll($criteria);

  	 // return self::model()->findAll('status=:pending OR status=:ready', array(':pending' => 'pending', ':ready' => 'ready'));
	  //return self::model()->findAll('status=:pending OR status=:ready', array(':pending' => 'pending', ':ready' => 'ready'));
  	}
  	
  	if('error' == $type)
  	{
          $criteria=new CDbCriteria();
          $criteria->condition = " `status` IN ('inprogress','error') ";
          $criteria->order = " email_recipient_id ASC ";
          $criteria->limit = 100;
          return self::model()->findAll($criteria);

  		//return self::model()->findAll('status=:1 OR status=:2', array(':1' => 'inprogress', ':2' => 'error'));
	  //return self::model()->findAll('status=:1 OR status=:2', array(':1' => 'inprogress', ':2' => 'error'));
  	}
  }
  
  /*
   * This method returns all values that are required to compose an email.
   * This method is implemented as part of the sendmail cron job.
   */
  public function getEmailParameters()
  {
  	$message = $this->emailMessageRef;
  	$type    = $message->emailTypeRef;

  	$params['subject']     =  $message->subject;
  	$params['body']        =  $message->body;
  	$params['fromEmail']   =  $type->from_email;
  	$params['fromName']    =  $type->from_name;
  	$params['replyTo']     =  $type->reply_to_email;
  	$params['toEmail']     =  $this->to_email;
  	$params['ccEmail']     =  $this->cc_email;
  	$params['toName']      =  $this->to_name;
  	// Getting EmailAttachment objects
  	$params['attachments'] =  $message->emailAttachments;
  	
  	return $params;
  	
  }
  
 
  
}