<?php

/**
 * This is the model class for table "lookup_likely_period".
 *
 * The followings are the available columns in table 'lookup_likely_period':
 * @property integer $period_id
 * @property string $months
 * @property integer $from_month
 * @property integer $to_month
 */
class LookupLikelyPeriod extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupLikelyPeriod the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_likely_period';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('months, from_month, to_month', 'required'),
			array('from_month, to_month', 'numerical', 'integerOnly'=>true),
			array('months', 'length', 'max'=>30),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('period_id, months, from_month, to_month', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'period_id' => 'Period',
			'months' => 'Months',
			'from_month' => 'From Month',
			'to_month' => 'To Month',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('period_id',$this->period_id);
		$criteria->compare('months',$this->months,true);
		$criteria->compare('from_month',$this->from_month);
		$criteria->compare('to_month',$this->to_month);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}