<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseScholarshipHostInstitute');

class ScholarshipHostInstitute extends BaseScholarshipHostInstitute
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  
  protected function beforeSave(){
      if(parent::beforeSave()){
        if($this->isNewRecord){
           $this->added_on = date('Y-m-d H:i:s');
        }else{
          $this->modified_on = date('Y-m-d H:i:s');
        }       
        return true;
      }
    return false;
  }

  
 /*
   * Get destination institutes 
   */
  public function getDestinationInstitute()
  {
  	  $criteria=new CDbCriteria;
	  $criteria->select = 't.country_ref_id';
//      $criteria->join = 'JOIN tbl_country_master cm ON t.country_ref_Id = cm.country_id';
      $criteria->with = array( 'countryRef' => array('select' => 'country_id, country_name') );
      $criteria->group = 'country_ref_id';
      $criteria->order = 'countryRef.country_name ASC';

      $data = self::model()->findAll($criteria);
      $countryList = array();
      foreach ($data as $val) {
          if ($val->countryRef->country_id  && $val->countryRef->country_name) {
          $countryList[$val->countryRef->country_id]  = $val->countryRef->country_name;
          }
      }

      return $countryList;
  	
  }
   public function getDestinationInstituteByCountry($countryIds = false)
  {
  	$criteria=new CDbCriteria;	
	$countryIdVal = $countryIds[0];
	
	if($countryIdVal == ',')
	{
		 $countryIdVals =substr($countryIds,1);		
	}
	else
	{
		$countryIdVals = $countryIds;
	}
	
    if(!empty($countryIdVals))
	{
		$criteria->condition = 'country_ref_id IN ('.$countryIdVals.')';
					
		$res = self::model()->findAll($criteria);	
		
		if($res)
		{
		  return $res;
		}
	}
  	else
  	{
  	  return false;	
  	}		
  }

    public static function getScholarshipByDeptUniId($uni_id, $dept_id) {
        $countryId = TblUniversityMaster::getUniCountryName($uni_id);
        $sql = "SELECT DISTINCT s.*, html_entity, frequency
                FROM `scholarship_host_institute` `shi`
                LEFT JOIN `scholarship` `s` ON shi.scholarship_ref_id = s.scholarship_id
                LEFT JOIN `lookup_currency` `lc` ON s.currency_ref_id = lc.currency_id
                LEFT JOIN `scholarship_department` `sd` ON sd.scholarship_ref_id =
                shi.scholarship_ref_id
                WHERE s.is_active = 1 AND 
                ((sd.main_dept_ref_id IN (".$dept_id.")) AND
                (shi.uni_ref_id IN (".$uni_id.") OR
                (shi.country_ref_id IN (".$countryId.") AND
                (shi.non_univariety_uni_name IS NULL OR
                shi.non_univariety_uni_name='') AND
                shi.uni_ref_id IS NULL)))";

        $cmd = Yii::app()->db->createCommand($sql);
        $scholarshipData = $cmd->queryAll();
        return count($scholarshipData);

    }

    /*
     *  Different calling parameter
     *  1. Only count of related scholarship for university
     *  getScholarshipCountByUniId(166)

     *  2. Only count of related scholarship for university and provider
     *  getScholarshipCountByUniId(166, 2)

     *  3. Only count of related scholarship for university and provider and department
     *  getScholarshipCountByUniId(166, 1, 74)
     *
     *  4. Data of related scholarship for university
     *  getScholarshipCountByUniId(166, '', '', 1)

     *  5. Data of related scholarship for university and provider
     *  getScholarshipCountByUniId(166, 1, '', 1)
     *
     *  6. Data of related scholarship for university and provider and department
     *  getScholarshipCountByUniId(166, 1, 74, 1)
     *
     */
     public static function getScholarshipCountByUniId($uni_id, $sProvider='', $mainDept = '', $fullData = '', $displayActiveScholarships = true) {
         $providerCond = "";
         if($sProvider != '') {
            $providerCond  = " AND sp.scholarship_provider_ref_id = ". $sProvider;
         }

         if($mainDept != '') {
             $mainDeptCond  = " AND sd.main_dept_ref_id = ". $mainDept;
         } else {
             $mainDeptCond = " AND sd.`main_dept_ref_id` IN (
            SELECT DISTINCT ld1.department_id
            FROM `tbl_university_master` um
            LEFT JOIN tbl_uni_courses uc ON um.`uni_id`=uc.`uni_ref_id`
            LEFT JOIN `lookup_department` ld ON uc.`department_ref_id`=ld.`department_id`
            LEFT JOIN `lookup_department` ld1 ON ld1.`department_id`=ld.`main_dept_id`
            WHERE uni_ref_id= '".$uni_id."'  AND course_level=6
            AND um.is_active='y'
            AND uc.is_active='Y' ) ";
         }

         $countryId = TblUniversityMaster::getUniCountryName($uni_id);

         /*
            $sqlSelect = "SELECT DISTINCT shi.`scholarship_ref_id`,sp.`scholarship_name`,shi.`country_ref_id`,`university_type`,`uni_ref_id`
            FROM scholarship_host_institute shi
            JOIN scholarship sp ON shi.scholarship_ref_id = sp.`scholarship_id`
            JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
            WHERE shi.country_ref_id = '".$countryId."' 
            AND shi.uni_ref_id = '".$uni_id."' 
            AND sp.is_active = 1 
            AND sd.course_level_ref_id=6
            AND shi.university_type = 'Univariety'
             $providerCond $mainDeptCond
            UNION ALL
            SELECT  DISTINCT shi.`scholarship_ref_id`,sp.`scholarship_name`,shi.`country_ref_id`,`university_type`,`uni_ref_id` 
            FROM scholarship_host_institute shi
            LEFT JOIN scholarship sp ON shi.scholarship_ref_id = sp.`scholarship_id`
            LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
            WHERE shi.country_ref_id = '".$countryId."' 
            AND shi.uni_ref_id IS NULL 
            AND sp.is_active = 1 
            AND sd.course_level_ref_id=6
            AND shi.university_type = 'Univariety'
             $providerCond $mainDeptCond";
         */

         if($displayActiveScholarships){
             $providerCond  .= " AND sp.is_active = 1";
         }

         $sqlSelect = "SELECT DISTINCT shi.`scholarship_ref_id`,sp.`scholarship_name`,shi.`country_ref_id`,`university_type`,`uni_ref_id`
            FROM scholarship_host_institute shi
            JOIN scholarship sp ON shi.scholarship_ref_id = sp.`scholarship_id`
            JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
            WHERE shi.country_ref_id = '".$countryId."'
            AND (shi.uni_ref_id = '".$uni_id."' OR shi.uni_ref_id IS NULL )
            AND sd.course_level_ref_id=6
            AND shi.university_type = 'Univariety'
             $providerCond $mainDeptCond";

          $cmd = Yii::app()->db->createCommand($sqlSelect);      
          $res = $cmd->queryAll();

        if($fullData) { return $res; } // If all data needed.

        return count($res);
         /*
         if($sProvider != '') {
            $providerCond  = " AND scholarship_provider_ref_id = ". $sProvider;
         }
        $countryId = TblUniversityMaster::getUniCountryName($uni_id);
        $scholarshipData = Yii::app()->db->createCommand()
                ->select('amount, html_entity, frequency')
                ->from('scholarship_host_institute AS shi')
                ->leftJoin('scholarship AS s', 'shi.scholarship_ref_id = s.scholarship_id')
                ->leftJoin('lookup_currency AS lc', 's.currency_ref_id = lc.currency_id')
                ->where("((uni_ref_id=:uni_id AND country_ref_id=:countryId) OR (uni_ref_id is null AND country_ref_id=:countryId AND (non_univariety_uni_name='')))". $providerCond , array(':uni_id' => $uni_id, 'countryId' => $countryId))                
                //->where("((uni_ref_id=:uni_id AND country_ref_id=:countryId) OR (uni_ref_id is null AND country_ref_id=:countryId AND (non_univariety_uni_name IS NULL OR non_univariety_uni_name='')))". $providerCond , array(':uni_id' => $uni_id, 'countryId' => $countryId))
                ->group("s.scholarship_id")
                ->queryAll();

        return count($scholarshipData); */
    }
    
    public static function getScholarshipCountByDeptUniId($uni_id, $dept_id, $sProvider='') {
        if($sProvider != '') {
            $providerCond  = " AND scholarship_provider_ref_id = ". $sProvider;
        }
        $countryId = TblUniversityMaster::getUniCountryName($uni_id);
        $scholarshipData = Yii::app()->db->createCommand()
            ->select('distinct(amount), html_entity, frequency')
            ->from('scholarship_host_institute AS shi')
            ->leftJoin('scholarship AS s', 'shi.scholarship_ref_id = s.scholarship_id')
            ->leftJoin('lookup_currency AS lc', 's.currency_ref_id = lc.currency_id')
            ->leftJoin('scholarship_department AS sd', 'sd.scholarship_ref_id = shi.scholarship_ref_id')
            ->where("((uni_ref_id=:uni_id AND shi.country_ref_id=:countryId) OR (uni_ref_id is null AND shi.country_ref_id=:countryId AND (non_univariety_uni_name IS NULL OR non_univariety_uni_name='') AND sd.main_dept_ref_id IN ($dept_id)))". $providerCond , array(':uni_id' => $uni_id, 'countryId' => $countryId))
            ->queryAll();

        return count($scholarshipData);
    }
    
     public static function getScholarshipDestinationCountryList() {
         $data = Yii::app()->db->createCommand()
            ->select('distinct(country_ref_id), country_id, country_name')
            ->from('scholarship_host_institute AS shi')
            ->join('tbl_country_master AS tcs', 'shi.country_ref_id = tcs.country_id')
            ->where("country_ref_id IS NOT NULL")
            ->queryAll();   
        $countryList = array();
        foreach ($data as $val) {
           $countryList[$val['country_id']]  = $val['country_name'];
        }
        asort($countryList);
        return $countryList;
    }    
   	
    public static function scholarshipApplicableForUniversityCount($scholarshipID = false,$universityId = false, $uniCountryId = false) {
        $sql = "SELECT COUNT(1) AS count
                FROM scholarship_host_institute 
                WHERE scholarship_ref_id = ".$scholarshipID." 
                AND ( uni_ref_id = ". $universityId ." OR ( uni_ref_id IS NULL  AND country_ref_id = ". $uniCountryId ." ) )";

        $cmd = Yii::app()->db->createCommand($sql);	

        $universityExamResult = $cmd->queryRow(); 	

        return $universityExamResult['count'];
        
    }
    
    public static function scholarshipApplicableForUniversitiesCount($scholarshipID = false, $excludeUniversities = false) {
        if($excludeUniversities) {
            $cond = "AND uni_ref_id NOT IN (". implode(",", $excludeUniversities) .")";
        }
        
        $sql = "SELECT count(1) AS count
                FROM scholarship_host_institute sh
                LEFT JOIN tbl_university_master tm ON tm.uni_id = sh.uni_ref_id
                WHERE tm.is_active = 'Y' AND scholarship_ref_id = ". $scholarshipID ." AND uni_ref_id IS NOT NULL ". $cond;
        
        $cmd = Yii::app()->db->createCommand($sql);	

        $universityExamResult = $cmd->queryRow(); 	

        return $universityExamResult['count'];

    }
    
	 public static function getScholarshipUniversityCount($scholarshipID = false,$universityIds = false)
	 {
		$where = '';
        if(!empty($universityIds))
		   $where = ' AND  SHI.uni_ref_id NOT IN ('.$universityIds.') ';
		   
	    $sql = "SELECT 
						 DISTINCT *
							FROM 
								tbl_university_master TUM
								LEFT JOIN scholarship_host_institute SHI ON SHI.uni_ref_id=TUM.uni_id							  
							WHERE 
								SHI.`scholarship_ref_id` = '".$scholarshipID."' AND SHI.uni_ref_id IS NOT NULL ".$where."  order by TUM.global_display_rank limit 0,20";
	 										  
	    $cmd = Yii::app()->db->createCommand($sql);	
		
	    $universityExamResult = $cmd->queryAll(); 	
		
		return count($universityExamResult);
				
     }  
     
     public function getRelatedScholarshipForUniversitiesAndCountries($uIds, $cIds, $sId = '') {
        if (is_array($cIds)) {
            $countryIds = implode(", ", $cIds);
            //$countryCond = " shi.country_ref_id IN (". $countryIds .") ";
        }

        if (is_array($uIds)) {
            $universityIds = implode(", ", $uIds);
            //$universityCond = " uni_ref_id IN (". $universityIds .") ";
        }

        if ($sId) {
            $scholarshipIdCond = " AND shi.scholarship_ref_id = " . $sId;
        }
        
        if( count($uIds) == 0 ) {
            return array();
        }

        $sqlSelect = "SELECT DISTINCT shi.`scholarship_ref_id`,sp.`scholarship_name`,shi.`country_ref_id`,`university_type`,`uni_ref_id`,`non_univariety_uni_name` 
            FROM scholarship_host_institute shi
            JOIN scholarship sp ON shi.scholarship_ref_id = sp.`scholarship_id`
            JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
            WHERE shi.country_ref_id IN ($countryIds) 
            AND shi.uni_ref_id IN ($universityIds)
            AND sp.is_active = 1
            AND course_level_ref_id=6
            AND shi.university_type = 'Univariety'
            AND sd.`main_dept_ref_id` IN (
            SELECT DISTINCT ld1.department_id
            FROM `tbl_university_master` um 
            LEFT JOIN tbl_uni_courses uc ON um.`uni_id`=uc.`uni_ref_id`
            LEFT JOIN `lookup_department` ld ON uc.`department_ref_id`=ld.`department_id`
            LEFT JOIN `lookup_department` ld1 ON ld1.`department_id`=ld.`main_dept_id`
            WHERE uni_ref_id IN ($universityIds) AND course_level=6
            AND um.is_active='y' 
            AND uc.is_active='Y' ) $scholarshipIdCond
            UNION ALL
            SELECT  DISTINCT shi.`scholarship_ref_id`,sp.`scholarship_name`,shi.`country_ref_id`,`university_type`,`uni_ref_id`,`non_univariety_uni_name` 
            FROM scholarship_host_institute shi
            LEFT JOIN scholarship sp ON shi.scholarship_ref_id = sp.`scholarship_id`
            LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
            WHERE shi.country_ref_id IN ($countryIds)  
            AND sp.is_active = 1 
            AND shi.uni_ref_id IS NULL 
            AND course_level_ref_id=6
            AND shi.university_type = 'Univariety'
            AND sd.`main_dept_ref_id` IN (
            SELECT DISTINCT ld1.department_id                            
            FROM `tbl_university_master` um 
            LEFT JOIN tbl_uni_courses uc ON um.`uni_id`=uc.`uni_ref_id`
            LEFT JOIN `lookup_department` ld ON uc.`department_ref_id`=ld.`department_id`
            LEFT JOIN `lookup_department` ld1 ON ld1.`department_id`=ld.`main_dept_id`
            WHERE um.uni_id IN ($universityIds)  
            AND course_level=6
            AND um.is_active='y' 
            AND uc.is_active='Y') $scholarshipIdCond";


        $cmd = Yii::app()->db->createCommand($sqlSelect);
        $res = $cmd->queryAll();

        return $res;
    }

    public static function scholarshipApplicableForUniversityCountOutplacement($scholarshipID = false,$universityId = false, $uniCountryId = false, $uni_name = false) {
        $sql = "SELECT COUNT(1) AS count
                FROM scholarship_host_institute
                WHERE scholarship_ref_id = ".$scholarshipID."
                AND ( uni_ref_id = ". $universityId ." OR ( uni_ref_id IS NULL  AND country_ref_id = ". $uniCountryId ." AND non_univariety_uni_name IS NULL ) )";

        $cmd = Yii::app()->db->createCommand($sql);

        $universityExamResult = $cmd->queryRow();

        return $universityExamResult['count'];

    }
     
     
}
