<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseStudentPreferredCareer');

class StudentPreferredCareer extends BaseStudentPreferredCareer {

    public $career_name;
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /*protected function beforeSave() {
        if (parent::beforeSave()) {
            if ($this->isNewRecord) {
                $this->added_on = date('Y-m-d H:i:s');
                return true;
            }
        }
        return false;
    }*/

    /*
     * Function to get student preferred career details
     * return array of career_ref_id, career_name
     */

    public function getStudentPreferredCareerDetails($user_id = 0) {
        $modelStudentPreferredCareer = self::model()->with(array("careerRef", array('select' => 'career_name')))->findAll(array("condition" => "user_ref_id = " . $user_id, "order" => "preference"));
        return $modelStudentPreferredCareer;
    }

  
    public function getStudentPreferredCareers($user_id=0)
    {
        $criteria = new CDbCriteria();
        $criteria->select = 'career_ref_id, preference, not_sure';
        $criteria->with = 'careerRef';
        $criteria->addCondition("user_ref_id = '".$user_id."'", "AND");
        //$criteria->addCondition("not_sure=0", "AND");
        $criteria->order = 'preference_order';
        $data = self::model()->findAll($criteria);
        return $data;
    }
    
    public function deleteCareerPreferenceByUserId($userId) {
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '" . $userId . "'";
        self::model()->deleteAll($criteria);
    }
    
    public function insertCareerPreferenceByUserId($userId, $careerId, $preferenceOrder){
        $obj = new StudentPreferredCareer();
        $obj->{user_ref_id} = $userId;
        $obj->{career_ref_id} = $careerId;
        $obj->{preference} = $preferenceOrder;
        $obj->save();
    }

    public function getStudentPreferredCareersAndDept($user_id=0)
    {
        $criteria = new CDbCriteria();
        $criteria->select = 'career_ref_id, preference, not_sure';
        $criteria->with = 'careerRef';
        $criteria->addCondition("user_ref_id = '".$user_id."'", "AND");
        $criteria->order = 'preference_order';
        $res = self::model()->findAll($criteria);
        foreach($res as $val){
            if($val->careerRef->main_dept_ref_id)
            {
                $data[$val->careerRef->main_dept_ref_id] = $val->careerRef->main_dept_ref_id;
            }
        }
        return $data;
    }
}