<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseStudentPreferredDepartment');

class StudentPreferredDepartment extends BaseStudentPreferredDepartment
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  
  
    public function behaviors(){
        return array(
            'StudentActivityFeedBehavior' => 'application.behaviors.StudentActivityFeedBehavior',
        );
    }        

    public function StudentActivityFeedLoggableAttributes(){
        return array(
            'main_dept_ref_id, sub_dept_ref_id' => 'preferred_departments',
        );
    }
  
  	
	public function getStudentsByCourse($siId=2)
	{
		$sql = " SELECT `sub_dept_ref_id`,department_name, COUNT( * ) as count
				FROM `student_preferred_department` spd
				JOIN tbl_si_students si ON si.user_ref_id = spd.user_ref_id
				JOIN lookup_department ld ON ld.department_id = spd.`sub_dept_ref_id`
				WHERE inst_ref_id = ".$siId."
				GROUP BY spd.`sub_dept_ref_id`";
		
		$sql = "SELECT `main_dept_ref_id`,department_name, COUNT( * ) as count
FROM `student_preferred_department` spd
JOIN tbl_si_students si ON si.user_ref_id = spd.user_ref_id
JOIN lookup_department ld ON ld.department_id = spd.`main_dept_ref_id`
WHERE inst_ref_id =".$siId."
GROUP BY spd.`main_dept_ref_id` ORDER By department_name";
		
		$rs = Yii::app()->db->createCommand($sql)->query();
		foreach($rs as $row)
		{
			$data[$row['department_name']] = $row['count'];
		}
		return $data;
	
	}
	
	/*
	 *Function to get Student Preferred Department details
	 *return department_id and department_name as array
	 */
	public function getStudentPreferredDepartmentDetails($user_id = 0)
	{
		$modelStudentPreferredDept = self::model()->with(array("mainDeptRef", array('JOIN TYPE'=>'LEFT OUTER JOIN')))->findAll(array("condition"=>"user_ref_id = ".$user_id, "order" => "preference_order"));
		return $modelStudentPreferredDept;
	}

    public function getStudentPreferredMainDepartmentNames($user_id=0)
    {
        $tempStudentPrefDeptArr = array();
        $studentPreferredDepartmentDetails = '';
        $modelStudentPreferredDept = self::getStudentPreferredDepartmentDetails($user_id);
        foreach($modelStudentPreferredDept as $spd){
            if($spd->attributes['not_sure'] == 1){
                $studentPreferredDepartmentDetails = 'Not sure';
            }else{
                $tempStudentPrefDeptArr[] = $spd->mainDeptRef->attributes['department_name'];
            }
        }
        if(count($tempStudentPrefDeptArr) > 0){
            $tempStudentPrefDeptArr = array_unique($tempStudentPrefDeptArr);
            $studentPreferredDepartmentDetails = implode('-- ', $tempStudentPrefDeptArr);
        }
        return $studentPreferredDepartmentDetails;
    }

	/*
	 * Function to get student preferred department names
	 * returns department_name as csv. 
	 * returns "Not sure", if not_sure flag is true
	 */
	public function getStudentPreferredDepartmentNames($user_id=0)
	{
		$tempStudentPrefDeptArr = array();
		$studentPreferredDepartmentDetails = '';
		$modelStudentPreferredDept = self::getStudentPreferredDepartmentDetails($user_id);
		foreach($modelStudentPreferredDept as $spd){
			if($spd->attributes['not_sure'] == 1){
				$studentPreferredDepartmentDetails = 'Not sure';
			}else{
				$tempStudentPrefDeptArr[] = $spd->subDeptRef->attributes['department_name'];
			}
		}
		if(count($tempStudentPrefDeptArr) > 0){
			$tempStudentPrefDeptArr = array_unique($tempStudentPrefDeptArr);
			$studentPreferredDepartmentDetails = implode(', ', $tempStudentPrefDeptArr);
		}
		return $studentPreferredDepartmentDetails;
	}
        
    public function deleteDepartmentPreferenceByUserId($userId) {
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '" . $userId . "'";
        self::model()->deleteAll($criteria);
    }
    
    public function insertDepartmentPreferenceByUserId($userId, $mainDeptId, $subDeptId, $preferenceOrder){
        $obj = new StudentPreferredDepartment();
        $obj->{user_ref_id} = $userId;
        $obj->{main_dept_ref_id} = $mainDeptId;
        $obj->{sub_dept_ref_id} = $subDeptId;
        $obj->{preference_order} = $preferenceOrder;
        $obj->save();
    }
    
    /*
	 * Function to get student preferred department details
	 * return array of model
	 */
	public function getStudentPreferredDepartments($user_id=0)
	{
		$modelStudentPreferredDepartment = self::model()->with(array("mainDeptRef", array('JOIN TYPE'=>'LEFT OUTER JOIN')))->findAll(array("condition"=>"user_ref_id = ".$user_id." AND not_sure=0", "order"=>"preference_order"));
		return $modelStudentPreferredDepartment;
	}
        
	public function getStudentPreferredDepartmentsPdf($user_id=0)
	{
            $criteria = new CDbCriteria();
            $criteria->select = 'main_dept_ref_id';
            $criteria->with = 'mainDeptRef';
            $criteria->addCondition("user_ref_id = '".$user_id."'", "AND");
            //$criteria->addCondition("not_sure=0", "AND");
            $criteria->order = 'preference_order';
            $data = self::model()->findAll($criteria);
            return $data;
	}       
        
        public function getStdDepartmentPrefByPrefOrder($userId, $prefOrder) {
            $modelStudentPreferredDepartment = self::model()->find(array("condition"=>"user_ref_id = ".$userId." AND preference_order = ". $prefOrder));
            return $modelStudentPreferredDepartment;

        }

    public function getStudentPreferredMainDepartmentIds($user_id=0)
    {
        $tempStudentPrefDeptArr = array();
        $studentPreferredDepartmentDetails = '';
        $modelStudentPreferredDept = self::getStudentPreferredDepartmentDetails($user_id);
        foreach($modelStudentPreferredDept as $spd){
            if($spd->attributes['not_sure'] == 1){
                $studentPreferredDepartmentDetails = 'Not sure';
            }else{
                $tempStudentPrefDeptArr[] = $spd->mainDeptRef->attributes['department_id'];
            }
        }
        if(count($tempStudentPrefDeptArr) > 0){
            $tempStudentPrefDeptArr = array_unique($tempStudentPrefDeptArr);
            $studentPreferredDepartmentDetails = implode(',', $tempStudentPrefDeptArr);
        }
        return $studentPreferredDepartmentDetails;
    }

    public function userPreferenceWiseDepartment($userId){

        $sql = "SELECT d.main_dept_ref_id, d.preference_order, ld.department_name
                FROM student_preferred_department d
                JOIN lookup_department ld ON ld.department_id = d.main_dept_ref_id
                WHERE user_ref_id = '".$userId."'
                ORDER BY preference_order ASC";

        $results = Yii::app()->db->createCommand($sql)->queryAll();
        return $results;
    }


    public function getStudentPreferredMainDepartmentNamesOnly($user_id=0)
    {
        $tempStudentPrefDeptArr = array();

        $modelStudentPreferredDept = self::getStudentPreferredDepartmentDetails($user_id);
        foreach($modelStudentPreferredDept as $spd){
            if($spd->attributes['not_sure'] == 1){
                $studentPreferredDepartmentDetails = 'Not sure';
            }else{
                $tempStudentPrefDeptArr[$spd->mainDeptRef->attributes['department_id']] = $spd->mainDeptRef->attributes['department_name'];
            }
        }

        return $tempStudentPrefDeptArr;
    }


    public static function getStudentIdsByPreferredCountryAndDepartment($countryId,$department,$type,$date){
        $sql = 'SELECT DISTINCT(spd.user_ref_id) FROM `student_preferred_department` spd
                JOIN tbl_user_master tu ON tu.user_id = spd.user_ref_id
                JOIN `student_preferred_country` spc ON spd.user_ref_id = spd.user_ref_id
                WHERE main_dept_ref_id = '.$department.' AND spc.country_ref_id = '.$countryId.' AND (spd.preference_order = 1 OR spd.preference_order = 0)
                AND (spc.preference_order = 1 OR spc.preference_order = 0)
                AND spd.user_ref_id IN(SELECT student_ref_id FROM (
                SELECT DISTINCT(uvsi.student_ref_id) FROM `uni_visit_pre_students_invited` uvsi
                WHERE uvsi.`student_ref_id` IS NOT NULL AND DATE(sent_on) BETWEEN DATE_SUB(\''.$date.'%\',INTERVAL 1 '.$type.') AND \''.$date.'%\'
                UNION ALL
                SELECT DISTINCT(uvpsi.student_ref_id) FROM `uni_visit_post_students_invited` uvpsi
                WHERE uvpsi.`student_ref_id` IS NOT NULL AND DATE(sent_on) BETWEEN DATE_SUB(\''.$date.'%\',INTERVAL 1 '.$type.') AND \''.$date.'%\' ) t GROUP BY student_ref_id)';

        $command = Yii::app()->db->createCommand($sql);
        $result = $command->queryAll();
        return CHtml::listData($result,'user_ref_id','user_ref_id');
    }

    public static function getStudentsAttended($countryId,$department,$type,$date){
        $sql = 'SELECT DISTINCT(spd.user_ref_id) FROM `student_preferred_department` spd
                JOIN tbl_user_master tu ON tu.user_id = spd.user_ref_id
                JOIN `student_preferred_country` spc ON spd.user_ref_id = spd.user_ref_id
                WHERE main_dept_ref_id = '.$department.' AND spc.country_ref_id = '.$countryId.' AND (spd.preference_order = 1 OR spd.preference_order = 0)
                AND (spc.preference_order = 1 OR spc.preference_order = 0)
                AND spd.user_ref_id IN(SELECT student_ref_id FROM (
                SELECT DISTINCT(uvsi.student_ref_id) FROM `uni_visit_pre_students_invited` uvsi
                WHERE uvsi.`student_ref_id` IS NOT NULL AND responded_on IS NOT NULL  AND DATE(sent_on) BETWEEN DATE_SUB(\''.$date.'%\',INTERVAL 1 '.$type.') AND \''.$date.'%\'
                UNION ALL
                SELECT DISTINCT(uvpsi.student_ref_id) FROM `uni_visit_post_students_invited` uvpsi
                WHERE uvpsi.`student_ref_id` IS NOT NULL AND responded_on IS NOT NULL AND DATE(sent_on) BETWEEN DATE_SUB(\''.$date.'%\',INTERVAL 1 '.$type.') AND \''.$date.'%\' ) t GROUP BY student_ref_id)';

        $command = Yii::app()->db->createCommand($sql);
        $result = $command->queryAll();
        return CHtml::listData($result,'user_ref_id','user_ref_id');
    }

}