<?php

/*
 * @author Asif Ali M
 * @package application.models
 *
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseStudentUploadMasterList');

class StudentUploadMasterList extends BaseStudentUploadMasterList {

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public $total_student;
    public $accepted;
    public $study_level;

    public function rules() {

        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('first_name, last_name, email_id, country_code, phone_number', 'required',  'message' => '<div class="holder"><p>Please enter {attribute}</p></div>'),
            array('study_level, board_ref_id,  completion_month, completion_year ', 'required',  'message' => '<div class="holder"><p>Please select {attribute}</p></div>'),
            array('first_name, last_name', 'match', 'pattern' => '/^[a-z ]*$/i', 'message' => '<div class="holder"><p>Strange name! Check again</p></div>'),
            array('inst_ref_id, board_ref_id, completion_month, completion_year', 'numerical', 'integerOnly' => true),
            //array('email_id', 'email', 'message'=>'<div class="holder"><p>Please enter valid email address</p></div>'),
            array('email_id', 'match', 'pattern' => '/^[ a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9 ])?$/', 'message' => '<div class="holder"><p>Enter a valid email</p></div>'),
            array('email_id','studentValidate'),
            array('phone_number', 'studentPhoneValidation'),
            array('country_code', 'numerical', 'integerOnly' => true, 'min'=>'1', 'tooSmall'=>'<div class="holder"><p>Country code is invalid.</p></div>', 'message' => '<div class="holder"><p>Country code should only contain numbers</p></div>'),
            array('country_code', 'length', 'min' => '1', 'max'=>'5', 'tooShort'=>'<div class="holder"><p>Country cannot be less than 1 digits.</p></div>', 'tooLong' => '<div class="holder"><p>Country code cannot be more than 5 digits.</p></div>'),
            array('phone_number', 'length', 'min' => '5', 'max' => '12', 'tooShort' => '<div class="holder"><p>Phone number cannot be less than 5 digits.</p></div>', 'tooLong' => '<div class="holder"><p>Phone number cannot be more than 12 digits.</p></div>'),
            array('country_code', 'match', 'pattern' => '/^[1-9]+[0-9]*$/i', 'message' => '<div class="holder"><p>Country code is invalid</p></div>'),
            array('phone_number', 'match', 'pattern' => '/^[1-9]+[0-9]*$/i', 'message' => '<div class="holder"><p>Phone number is invalid</p></div>'),
            array('user_ref_id, added_by, modified_by', 'length', 'max' => 10),
            array('first_name, last_name', 'length', 'max' => 100),
            array('email_id', 'length', 'max' => 255),
            array('country_code', 'length', 'max' => 4),
            array('phone_number', 'length', 'max' => 50),
            array('class', 'length', 'max' => 2),
            array('section, gender', 'length', 'max' => 1),
            array('invitation_status', 'length', 'max' => 8),

            array('added_on, added_by, modified_on', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('student_upload_master_list_id, inst_ref_id, user_ref_id, first_name, last_name, email_id, class, board_ref_id, section, gender, completion_month, completion_year invitation_status, added_on, added_by, modified_on, modified_by', 'safe', 'on' => 'search'),
        );
    }
    
    /**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_upload_master_list_id' => 'Student Upload Master List',
			'inst_ref_id' => 'Inst Ref',
			'user_ref_id' => 'User Ref',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'email_id' => 'Email',
			'country_code' => 'Country Code',
			'phone_number' => 'Phone Number',
			'class' => 'Class',
			'class_status' => 'Class Status',
			'board_ref_id' => 'Board',
			'section' => 'Section',
			'gender' => 'Gender',
			'completion_month' => 'Completion Month',
			'completion_year' => 'Completion Year',
			'invitation_status' => 'Invitation Status',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

    public static function getUploadStudentList($emailid) {
        $studentList = self::model()->find('email_id=:emailid', array(':emailid' => $emailid));
        if ($studentList) {
            return $studentList;
        } else {
            return false;
        }
    }

    public static function getAllUploadStudentList($instRefId = false, $invitationStatus = false) {
        $criteria = new CDbCriteria();


        if (!empty($instRefId) && empty($invitationStatus)) {
            $criteria->condition = 'inst_ref_id= ' . $instRefId;
            $criteria->order = 'added_on desc';
            $studentList = self::model()->findAll($criteria);
            // $studentList = self::model()->findAll('inst_ref_id=:instRefId', array(':instRefId' => $instRefId));
        } else if (!empty($instRefId) && !empty($invitationStatus)) {
            $criteria->condition = "inst_ref_id= '" . $instRefId . "' AND invitation_status = '" . $invitationStatus . "'";
            $criteria->order = 'added_on desc';
            $studentList = self::model()->findAll($criteria);
        } else {
            $criteria->order = 'added_on desc';
            $studentList = self::model()->findAll($criteria);
        }


        if ($studentList) {
            return $studentList;
        } else {
            return false;
        }
    }

    public function studentValidate($attribute, $params) {

        if (empty($this->student_upload_master_list_id))
            $studentList = self::model()->count('email_id=:emailId', array(':emailId' => $this->email_id));
            
        else{
            $studentList = self::model()->count("email_id='" . $this->email_id . "' AND student_upload_master_list_id <> '" . $this->student_upload_master_list_id . "'");
        }
        if(!$studentList){
                $studentList = LoginMaster::model()->count('username=:emailId', array(':emailId' => $this->email_id));
        }

        if ($studentList > 0) {

            $this->addError($attribute, '<div class="holder"><p>Email address with "' . $this->email_id . '" already exists</p></div>');
            return false;
        } else {
            return true;
        }
    }

//	/**
//	 * @return array relational rules.
//	 */
//	public function relations()
//	{
//	    // NOTE: you may need to adjust the relation name and the related
//		// class name for the relations automatically generated below.
//		return array(
//			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
//		);
//	}

    public function insertStudentUploadList($params) {

        $model = new StudentUploadMasterList();

        /** Get Board equivalent ** */
        $lookupBoard = LookupBoard::GetSchoolIds($params['boardRefId']);


        if ($params['gender'] == 'Female')
            $gender = 'F';
        else if ($params['gender'] == 'Male')
            $gender = 'M';

        if (!empty($params['country_code']) && ($params['country_code'][0] == '+' || $params['country_code'][0] == '-'))
            $params['country_code'] = substr($params['country_code'], 1);

        if (!empty($params['phoneNumber']) && ($params['phoneNumber'][0] == 0 || $params['phoneNumber'][0] == '+' || $params['phoneNumber'][0] == '-'))
            $params['phoneNumber'] = substr($params['phoneNumber'], 1);


        $model->first_name = $params['firstName'];
        $model->last_name = $params['lastName'];
        $model->email_id = $params['userName'];
        $model->inst_ref_id = $params['instId'];
        $model->country_code = $params['countryCode'];
        $model->phone_number = $params['phoneNumber'];

        $model->class = $params['class'];
        $model->class_status = $params['status'];
        $model->board_ref_id = $lookupBoard->attributes['board_id'];
        $model->section = $params['section'];
        $model->gender = $gender;
        $model->completion_month = $params['completion_month'];
        $model->completion_year = $params['completion_year'];
        $model->invitation_status = 'Invited';
        $model->added_on = date('Y-m-d H:i:s');
        $model->added_by = Yii::app()->user->id;
        $test = $model->save(false);
        //$student_upload_master_list_id = $model->student_upload_master_list_id;

//        $sql = "update student_upload_master_list set last_name='" . $mode1->last_name . "' where student_upload_master_list_id = '" . $student_upload_master_list_id . "'";
//        $command = Yii::app()->db->createCommand($sql);
//        $command->execute();
    }

    /*
     * Function to validate email 
     */

    public function studentListValidate($param) {

        $errorMsg = "";
        $schoolBoard = 1;

        if(strlen($param['firstName']) == 0) {
            $errorMsg .= 'Please upload csv with First Name in row '.$param['currRow'].'<br>';
        }

        if (is_numeric($param['firstName'])) {
            $errorMsg .= 'First name should be alphabet in row ' . $param['currRow'] . '<br>';
        }

        if (is_numeric($param['lastName'])) {
            $errorMsg .= 'Last name should be alphabet in in row ' . $param['currRow'] . '<br>';
        }
        if ($param['class'] != '11' && $param['class'] != '12' && $param['class'] != '9' && $param['class'] != '10') {
            $errorMsg .= 'Please upload csv with current study level as 9/10/11/12 in row ' . $param['currRow'] . '<br>';
        }
        if ($param['status'] != 'Complete' && $param['status'] != 'Pursuing') {////TODO: #994 changed 'Complete' to Completed Fields
            $errorMsg .='Please upload csv with status as Complete/Pursuing in row ' . $param['currRow'] . '<br>';
        }
        /*if ($param['gender'] != 'Male' && $param['gender'] != 'Female') {
            $errorMsg .= 'Please upload csv with gender as Male/Female in row ' . $param['currRow'] . '<br>';
        }*/
        if ($schoolBoard == 0) {
            $errorMsg .= 'Please upload csv with valid board/curriculum in row ' . $param['currRow'] . '<br>';
        }

        /* if(strlen($param['countryCode']) == 0)
          {
          $errorMsg .= 'Please upload csv with country code in row '.$param['currRow'].'<br>';
          }
          else */
        /*if ($param['countryCode'] != "") {

            if (!(is_numeric($param['countryCode']))) {
                $errorMsg .= 'Please upload csv with valid country code in row ' . $param['currRow'] . '<br>';
            }
        }*/

        /* if(strlen($param['phoneNumber']) == 0)
          {
          $errorMsg .= 'Please upload csv with mobile number in row '.$param['currRow'].'<br>';
          }
          else
         */
        /*if ($param['phoneNumber'] != "") {
            $valid = self::err_chkPhoneNumber($param['phoneNumber'], 'mobile number');
            if ($valid == 1)
                $errorMsg .= 'Please upload csv with valid mobile number in row ' . $param['currRow'] . '<br>';
            else if ($valid == 2)
                $errorMsg .= 'Please upload csv with mobile number should not start with "0" in row ' . $param['currRow'] . '<br>';
        }*/

        if ($schoolBoard == 0) {
            $errorMsg .= 'Please upload csv with valid board/curriculum in row ' . $param['currRow'] . '<br>';
        }

        if ($param['completion_year'] == "") {
            $errorMsg .= 'completion year missing in row ' . $param['currRow'] . '<br>';
        } elseif (!(is_numeric($param['completion_year']))) {
            $errorMsg .= 'Completion year should be numeric in row ' . $param['currRow'] . '<br>';
        } elseif (strlen($param['completion_year']) != 4) {
            $errorMsg .= 'Completion year is invalid in row ' . $param['currRow'] . '<br>';
        }
        $isValid = "";

        $isValid = LoginMaster::chkValidEmail($param['userName']);

        $studentList = self::model()->count('email_id=:emailId', array(':emailId' => $param['userName']));
        $loginMasterCount = LoginMaster::model()->count('username=:emailId', array(':emailId' => $param['userName']));

        if ($studentList > 0) {
            $errorMsg .= 'Email id with "' . $param['userName'] . '" already exists in row ' . $param['currRow'] . '<br>';
        } else if ($isValid > 0) {
            $errorMsg .= 'Please enter valid email id "' . $param['userName'] . '" in row ' . $param['currRow'] . '<br>';
        }

        return $errorMsg;
    }

    public function updateMasterList($pk, $fieldName, $fieldValue = NULL) {
        self::model()->updateByPk($pk, array($fieldName => $fieldValue));
    }

    public function getSiUploadStudents($term = false, $instId = false) {

        $res = self::model()->findAll(array('condition' => 'inst_ref_id = "' . $instId . '" and ( first_name like "%' . $term . '%"  or last_name like "%' . $term . '%" or email_id like "%' . $term . '%")'));
        foreach ($res as $result) {

            $op[] = array(
                'id' => $result['student_upload_master_list_id'],
                'value' => $result['email_id'],
            );
        }
        return $op;
    }

    public function invitedCount($sId = false) {

        $accepted = StudentUploadMasterList::getAllUploadStudentList($sId, 'Accepted');
        if (!empty($accepted))
            $acceptedCount = sizeof($accepted); else
            $acceptedCount = "0";

        $pending = StudentUploadMasterList::getAllUploadStudentList($sId, 'Pending');
        if (!empty($pending))
            $pendingCount = sizeof($pending); else
            $pendingCount = "0";
        $invitedCount = $acceptedCount + $pendingCount;
        return $invitedCount;
    }

    public function err_chkPhoneNumber($val, $valText) {
        if (strlen($val) > 0) {
            if (!(is_numeric($val)))
                $errMsg = 1;
            else
            if ($val[0] == 0)
                $errMsg = 2;
        }
        return($errMsg);
    }

    public static function updateInvitedStudentInfoByEmail($emailId, $fields = array()) {
        $model = new StudentUploadMasterList();
        $model->updateAll($fields, 'email_id=:emailId', array(':emailId' => $emailId));
    }

    public static function getStudentCountByClass($instId) {
        
        //$schoolId = TblSiDi::GetSchoolLookupId($instId);
        $sql = "SELECT  COUNT(user_id) as profile_created, COUNT(student_upload_master_list_id) as pending, user_id, present_class , present_board_ref_id, passout_year
                FROM 
                   (SELECT user_id,NULL AS student_upload_master_list_id, present_class , present_board_ref_id, passout_year 
                    FROM tbl_user_master as tum
                    INNER JOIN tbl_si_students tss ON tss.user_ref_id = tum.user_id
                    WHERE inst_ref_id=" . $instId . " AND present_class IN ('9','10','11', '12')
                    UNION ALL
                    SELECT NULL,student_upload_master_list_id, class, board_ref_id, completion_year AS user_id 
                    FROM student_upload_master_list 
                    WHERE inst_ref_id=" . $instId . " AND class IN ('9','10','11', '12') AND user_ref_id IS NULL
                   ) t
                GROUP BY present_class, present_board_ref_id,passout_year 
                ORDER BY present_class DESC,present_board_ref_id ASC, passout_year DESC ";

        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
//        
    }


    public static function getPendingStudentDetailByClass($instId = 0, $class = '', $board = '', $graduatioYear = '', $limit = 0, $offset = 0) {
        $criteria = new CDbCriteria();
        $criteria->compare('class', $class);
        $criteria->compare('board_ref_id', $board);
        $criteria->compare('completion_year', $graduatioYear);
        $criteria->addCondition("inst_ref_id = " . $instId . " AND user_ref_id IS NULL ");
        $criteria->offset = $offset;
        if ($limit) {
            $criteria->limit = $limit;
        }

        $result = self::model()->findAll($criteria);
        return $result;
    }
     public static function getUniqueCompletionYearList($instId = 68) {
        $criteria = new CDbCriteria();
        $criteria->select = 'completion_year';
        $criteria->condition = "inst_ref_id = :instId  AND class IN ('11','12')";
        $criteria->params = array(':instId' => $instId);
        $criteria->group = 'completion_year';
        $criteria->order = 'completion_year';
        $result = self::model()->findAll($criteria);
        return $result;
    }
        
  public static function uploadlistByBoard($instId,$class,$passout_year,$boardId)
  {
    $sql = "SELECT board_ref_id,COUNT(*) AS 'total' 
             FROM student_upload_master_list
             WHERE inst_ref_id='$instId' AND class='$class' AND completion_year='$passout_year' AND class_status='Pursuing' AND board_ref_id='$boardId'
           ";
    $cmd = Yii::app()->db->createCommand($sql);
    $res = $cmd->queryAll();
    return $res;
  }
  
  public static function getUploadlistByBoard($instId,$class,$passout_year,$boardId)
  {
    $sql = "SELECT user_ref_id,email_id
             FROM student_upload_master_list
             WHERE inst_ref_id='$instId' AND class='$class' AND completion_year='$passout_year' 
             AND class_status='Pursuing' AND board_ref_id='$boardId' ";
    $cmd = Yii::app()->db->createCommand($sql);
    $res = $cmd->queryAll();
    return $res;
  }

    public function getCountryCodes() {
        $result = TblCountryMaster::model()->findAll('is_active= "Y" AND country_code <> "" ORDER BY country_code ASC ');
        return CHtml::listData($result, 'phone_code', function($country) { return $country->country_name." (+".$country->phone_code.")"; } );
    }

    public function studentPhoneValidation() {

        if ($this->country_code == 91) {
            /*
            $res = file_get_contents('http://www.bmobile.in/'.$this->phone_number);

            $res_arr = explode('<table class="table table-hover table-condensed "><tbody>', $res);
            $res_arr1 = explode('</tbdy>', $res_arr[1]);

            $count = 0;
            $count = substr_count($res_arr1[0], $this->phone_number); */

            if($this->phone_number[0] < 7){
                $this->addError('phone_number', '<div class="holder"><p>Enter a valid mobile number</p></div>');
            }
        }
    }
    
      public static function getTotalStudentCountAndAlumniCount($instId,$year = '',$filterYear = '',$filterBoard = ''){

        if(($filterYear == '' && $filterBoard == '')  && $year!=''){

            $conditionsql1 = ' AND passout_year <='.$year.' AND passout_year <> 0';
            $conditionsql2 = ' AND completion_year <= '.$year.' AND completion_year <> 0';
            $conditionsql3 = ' AND tu.passout_year <= '.$year.' AND tu.passout_year <> 0';
        }

        if($year !='' && $filterYear != '' && $filterBoard != ''){

            $conditionsql1 = ' AND passout_year ='.$filterYear.' AND present_board_ref_id = '.$filterBoard.' AND passout_year <> 0 ';
            $conditionsql2 = ' AND completion_year ='.$filterYear.' AND board_ref_id = '.$filterBoard.' AND completion_year <> 0';
            $conditionsql3 = ' AND tu.passout_year ='.$filterYear.' AND tu.present_board_ref_id = '.$filterBoard.' AND tu.passout_year <> 0' ;
        }

        if($year !='' && ($filterYear == '' && $filterBoard != '')){
            $conditionsql1 = ' AND present_board_ref_id ='.$filterBoard.' AND passout_year <='.$year.' AND passout_year <> 0';
            $conditionsql2 = ' AND board_ref_id ='.$filterBoard.' AND completion_year <= '.$year.' AND completion_year <> 0';
            $conditionsql3 = ' AND tu.present_board_ref_id ='.$filterBoard.' AND tu.passout_year <= '.$year.' AND tu.passout_year <> 0' ;
        }

        if($year !='' && ($filterYear != '' && $filterBoard == '')){

            $conditionsql1 = ' AND passout_year ='.$filterYear.' AND passout_year <> 0';
            $conditionsql2 = ' AND completion_year ='.$filterYear.' AND completion_year <> 0';
            $conditionsql3 = ' AND tu.passout_year ='.$filterYear.' AND tu.passout_year <> 0' ;
        }


        $sql = 'SELECT  COUNT(user_id) AS profile_created, COUNT(student_upload_master_list_id) AS pending, user_id, present_board_ref_id, passout_year,COUNT(alumni)AS alumni_count
                FROM
                   (SELECT user_id,NULL AS student_upload_master_list_id, present_class , present_board_ref_id, passout_year,NULL AS alumni
                    FROM tbl_user_master AS tum
                    INNER JOIN tbl_si_students tss ON tss.user_ref_id = tum.user_id
                    WHERE inst_ref_id='.$instId.$conditionsql1.'
                    UNION ALL

                    SELECT NULL,student_upload_master_list_id, class, board_ref_id, completion_year AS user_id ,NULL AS alumni
                    FROM student_upload_master_list
                    WHERE inst_ref_id='.$instId.$conditionsql2.'
                    AND user_ref_id IS NULL

                    UNION ALL

                    SELECT NULL,NULL,tu.present_class,tu.present_board_ref_id,tu.passout_year,soc.user_ref_id AS alumni
                    FROM `student_outplacement_colleges` soc
                    INNER JOIN tbl_user_master tu ON tu.user_id = soc.user_ref_id
                    INNER JOIN tbl_si_students tss ON tss.user_ref_id = soc.user_ref_id
                    LEFT JOIN `student_outplacement_tests` sot ON soc.user_ref_id = sot.user_ref_id
                    WHERE tss.inst_ref_id = '.$instId.$conditionsql3.'
                    GROUP BY soc.user_ref_id
                   ) t
                GROUP BY present_board_ref_id,passout_year
                ORDER BY present_board_ref_id ASC, passout_year DESC';



        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }
}

