<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseTblSiBoard');

class TblSiBoard extends BaseTblSiBoard
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }






  
	public static function getSiBoards($siRefId = 0){
		$cdb = new CDbCriteria();
		$cdb->join = "LEFT JOIN lookup_board lb ON (t.board_ref_id = lb.board_id)";
		$cdb->condition = "t.si_ref_id = ".$siRefId;
		$results = self::model()->findAll($cdb);
		return $results;
	}
  
	
  
  
   public static function getSchoolBoardList($instRefId = false)
  {
    $result = self::model()->with('boardRef')->findAll('si_ref_id=:instRefId', array(':instRefId' => $instRefId));
	
	if($result)
	{
	  return $result;
	}
	else
	{
	  return false;	
	}
  }
  
  public static function getSchoolBoardEquivalentList($instRefId = false, $class = '') {

         $sql ="SELECT board_equivalent_id, lb.board_desc,lb.board_id FROM tbl_si_board tsb
                    INNER JOIN lookup_board lb ON tsb.board_ref_id = lb.board_id  AND si_ref_id = " . $instRefId . "  
                    INNER JOIN lookup_board_equivalent t ON lb.board_id = t.board_ref_id
                    WHERE t.class_level = '".$class."' ORDER BY lb.board_desc";

        $command =Yii::app()->db->createCommand($sql);
        $res =$command->queryAll();
        return $res;
  }

    public static function getSchoolBoardByCategory($instRefId = false, $class = '', $isMainBoard = false) {

        $sql = "SELECT board_equivalent_id, lb.board_desc,lb.board_id,lb.board_category, t.board_name FROM tbl_si_board tsb
                    INNER JOIN lookup_board lb ON tsb.board_ref_id = lb.board_id  AND si_ref_id = " . $instRefId . "
                    INNER JOIN lookup_board_equivalent t ON lb.board_id = t.board_ref_id
                    WHERE t.class_level = '".$class."' ORDER BY lb.board_category,lb.board_desc";

        $boards = Yii::app()->db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        $boardList = array();
        foreach($boards as $board)
        {
            if($isMainBoard) {
                $boardList[$board->board_category][$board->board_id] = $board->board_name;
                //$boardList[$board->board_category][$board->board_id] = $board->board_desc;
            }
            else {
                $boardList[$board->board_category][$board->board_equivalent_id] = $board->board_name;
            }
        }
        return $boardList;

    }

    public static function getSchoolMainBoardByCategory($instRefId = false) {

        $sql = "SELECT board_equivalent_id, lb.board_desc,lb.board_id,lb.board_category,t.board_name FROM tbl_si_board tsb
                    INNER JOIN lookup_board lb ON tsb.board_ref_id = lb.board_id  AND si_ref_id = " . $instRefId . "
                    INNER JOIN lookup_board_equivalent t ON lb.board_id = t.board_ref_id ORDER BY lb.board_desc";

        $boards = Yii::app()->db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        $boardList = array();
        foreach($boards as $board)
        {
            $boardList[$board->board_category][$board->board_equivalent_id] = $board->board_name;
        }
        return $boardList;

    }
}