<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseTblUniCourses');

class TblUniCourses extends BaseTblUniCourses {

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    public $fees;
    public static function getDepartmentListByUniId($uniId, $course_level = '', $is_active = '') {

        if ($course_level == 'ug') {
            $inCondition = 'AND course_level in (6,7)';
        } elseif ($course_level == 'pg') {
            $inCondition = 'AND course_level in (2,3,4)';
        }

        $cond = '';
        if ($is_active != '') {
            $cond = " AND uc.is_active = 'Y' ";
        }

        $sql = "SELECT DISTINCT ld1.department_id AS id, ld1.department_name AS value FROM tbl_university_master t
			    INNER JOIN tbl_uni_courses uc ON uc.uni_ref_id = t.uni_id
			    INNER JOIN lookup_department ld ON ld.department_id = uc.department_ref_id
			    INNER JOIN lookup_department ld1 ON ld1.department_id = ld.main_dept_id
			    WHERE t.uni_id = :university $inCondition $cond ORDER BY ld1.department_name ASC";
        $command = Yii::app()->db->createCommand($sql);
        $command->bindValue(":university", $uniId, PDO::PARAM_INT);
        $res = $command->queryAll();
        return $res;
    }

    public static function getUniverstityMainDepartmentWithCourseCount($uni_id, $course_level) {

        if ($course_level == 'ug') {
            $inCondition = 'AND course_level in (6,7)';
        } elseif ($course_level == 'pg') {
            $inCondition = 'AND course_level in (2,3,4)';
        }
        $mainDepartment = Yii::app()->db->createCommand()
                ->select('uni_ref_id, ld_main.department_id, ld_main.department_name, COUNT(ld_main.department_id) as course_count, GROUP_CONCAT(DISTINCT(ld.department_id)) AS sub_department_ids')
                ->from('tbl_uni_courses AS uc')
                ->join('lookup_department AS ld', 'uc.department_ref_id = ld.department_id')
                ->join('lookup_department AS ld_main', 'ld_main.department_id = ld.main_dept_id')
                ->where("uni_ref_id=:id and uc.is_active = 'Y' " . $inCondition, array(':id' => $uni_id))
                ->group('department_name')
                ->queryAll();
        return $mainDepartment;
    }

    public static function getCourseByDepartmentId($uni_id, $dept_id, $course_level,$subdeptId=false) {
        if ($course_level == 'ug') {
            $inCondition = ' AND course_level in (6,7)';
        } elseif ($course_level == 'pg') {
            $inCondition = ' AND course_level in (2,3,4)';
        } elseif ($course_level == 5) {
            $inCondition = ' AND course_level in (6,7)';
        } elseif ($course_level == 1) {
            $inCondition = ' AND course_level in (2,3,4)';
        } elseif ($course_level == 10) {
            $inCondition = ' AND course_level in (11,13)';
        } elseif ($course_level == 8) {
            $inCondition = ' AND course_level in (9)';
        }
        if($subdeptId)
        {
            $subDeptsql = " AND department_id=".$subdeptId." ";
        }

        $sql = 'SELECT  uni_ref_id,
                course_name,
                url_primary_key,
                course_id,
                department_name AS sub_dept_name,
                html_entity,
                admission_page_link,
                course_page_link,
                course_fees_duration_ref_id,
                course_fees_duration_ref_id,
                IF((course_fees_duration_id IN(1,2,3,4,5)),
                course_fees_duration_id,
                IF((course_fees_duration_id=8)," / Year",IF((course_fees_duration_id=7)," / Semester",""))) AS duration,

                (SELECT IF (
                    (SELECT cf1.fees FROM course_fees cf1
                    WHERE cf1.uni_course_ref_id = uc.course_id
                    AND cf1.reservation_ref_id = 1
                    AND cf1.course_fees_duration_ref_id IN(6))
                     > 0 ,
                    (SELECT cf1.fees*IF(rate,rate,1) FROM course_fees cf1
                    LEFT JOIN lookup_currency_conversion lcc ON lcc.from_currency_ref_id = cf1.currency_ref_id AND to_currency_ref_id=1
                    WHERE cf1.uni_course_ref_id = uc.course_id
                    AND cf1.reservation_ref_id = 1
                    AND cf1.course_fees_duration_ref_id IN(6)),

                    (SELECT SUM(cf2.fees*IF(rate,rate,1)) AS fees FROM course_fees cf2
                    LEFT JOIN lookup_currency_conversion lcc ON lcc.from_currency_ref_id = cf2.currency_ref_id AND to_currency_ref_id=1
                    WHERE cf2.uni_course_ref_id = uc.course_id
                    AND cf2.reservation_ref_id = 1
                    AND cf2.course_fees_duration_ref_id NOT IN(6))
                 )) fees,

                (SELECT COUNT(reservation_ref_id)
                FROM course_fees cf1
                WHERE cf1.uni_course_ref_id = uc.course_id
                AND cf1.reservation_ref_id = 1 AND course_fees_duration_ref_id!=6) AS fee_years,
                course_duration, lc.currency_id
               FROM `tbl_uni_courses` `uc`
               JOIN `lookup_department` `ld` ON uc.department_ref_id = ld.department_id
               LEFT JOIN `course_fees` `cf` ON cf.`uni_course_ref_id` = uc.course_id
               LEFT JOIN `lookup_currency` `lc` ON cf.currency_ref_id = lc.currency_id
               LEFT JOIN `lookup_course_fees_duration` `lcfd` ON
               cf.course_fees_duration_ref_id = lcfd.course_fees_duration_id
               LEFT JOIN `lookup_reservation` `lr` ON lr.reservation_id =
               cf.reservation_ref_id
               WHERE uc.is_active = "Y"
               AND uni_ref_id='.$uni_id.'
               AND main_dept_id='.$dept_id.'
               '.$subDeptsql.'
               '. $inCondition .'
               GROUP BY course_id
               ORDER BY
               course_fees_duration_ref_id = 6 DESC,
               course_fees_duration_ref_id = 8 DESC,
               course_fees_duration_ref_id = 1 DESC,
               course_fees_duration_ref_id = 2 DESC,
               course_fees_duration_ref_id = 3 DESC,
               course_fees_duration_ref_id = 4 DESC,
               course_fees_duration_ref_id = 5 DESC,
               course_fees_duration_ref_id = 7 DESC,
               course_fees_duration_ref_id = 9 DESC';
        
        $departmentCourse = Yii::app()->db->createCommand($sql)->queryAll();
//                ->select('uni_ref_id, course_name, course_id, department_name AS sub_dept_name, html_entity, admission_page_link, course_page_link, 
//                    IF((course_fees_duration_id IN(1,2,3,4,5)), course_fees_duration_id, IF((course_fees_duration_id=8)," / Year",IF((course_fees_duration_id=7)," / Semester","")))
//                     as duration, SUM(fees) AS fees, COUNT(course_id) AS fee_years, course_duration')
//                ->from('tbl_uni_courses AS uc')
//                ->join('lookup_department AS ld', 'uc.department_ref_id = ld.department_id')
//                ->leftJoin('course_fees AS cf', 'cf.`uni_course_ref_id` = uc.course_id')
//                ->leftjoin('lookup_currency AS lc', 'cf.currency_ref_id = lc.currency_id')
//                ->leftjoin('lookup_course_fees_duration AS lcfd', 'cf.course_fees_duration_ref_id = lcfd.course_fees_duration_id')
//                ->leftjoin('lookup_reservation AS lr', 'lr.reservation_id = cf.reservation_ref_id')
//                ->where("uc.is_active = 'Y' AND reservation_ref_id = 1 and uni_ref_id=:uni_id and main_dept_id=:dept_id " . $inCondition, array(':uni_id' => $uni_id, ':dept_id' => $dept_id))
//                ->group('course_id')
//                ->queryAll();
        return $departmentCourse;
    }
    
     public static function getInternationalCourseByDepartmentId($uni_id, $dept_id, $course_level, $subdeptId=false) {
        if ($course_level == 'ug') {
            $inCondition = ' AND course_level in (6,7)';
        } elseif ($course_level == 'pg') {
            $inCondition = ' AND course_level in (2,3,4)';
        } elseif ($course_level == 5) {
            $inCondition = ' AND course_level in (6,7)';
        } elseif ($course_level == 1) {
            $inCondition = ' AND course_level in (2,3,4)';
        } elseif ($course_level == 10) {
            $inCondition = ' AND course_level in (11,13)';
        } elseif ($course_level == 8) {
            $inCondition = ' AND course_level in (9)';
        }
         if($subdeptId)
         {
             $subDeptsql = " AND department_id=".$subdeptId." ";
         }
        $sql = 'SELECT  uni_ref_id,
                course_name,
                course_id,
                url_primary_key,
                department_name AS sub_dept_name,
                html_entity,
                admission_page_link,
                course_page_link,
                fee_page_link,
                IF((course_fees_duration_id IN(1,2,3,4,5)),
                course_fees_duration_id,
                IF((course_fees_duration_id=8)," / Year",IF((course_fees_duration_id=7)," / Semester",IF((course_fees_duration_id=9)," / Trimester","")))) AS duration,
                (SELECT SUM(fees)
                FROM course_fees cf1
                LEFT JOIN lookup_currency_conversion lcc ON lcc.from_currency_ref_id = cf1.currency_ref_id AND to_currency_ref_id=1
                WHERE cf1.uni_course_ref_id = uc.course_id
                AND cf1.reservation_ref_id = 30) AS fees,
                (SELECT COUNT(reservation_ref_id)
                FROM course_fees cf1
                WHERE cf1.uni_course_ref_id = uc.course_id
                AND cf1.reservation_ref_id = 30) AS fee_years,
                course_duration, lc.currency_id
               FROM `tbl_uni_courses` `uc`
               JOIN `lookup_department` `ld` ON uc.department_ref_id = ld.department_id
               LEFT JOIN `course_fees` `cf` ON cf.`uni_course_ref_id` = uc.course_id
               LEFT JOIN `lookup_currency` `lc` ON cf.currency_ref_id = lc.currency_id
               LEFT JOIN `lookup_course_fees_duration` `lcfd` ON
               cf.course_fees_duration_ref_id = lcfd.course_fees_duration_id
               LEFT JOIN `lookup_reservation` `lr` ON lr.reservation_id =
               cf.reservation_ref_id
               WHERE uc.is_active = "Y"
               AND uni_ref_id='.$uni_id.'
               AND main_dept_id='.$dept_id.'
               '.$subDeptsql.'
               '. $inCondition .'
               GROUP BY course_id';
               // SELECT fees*IF(rate,rate,1)
        $departmentCourse = Yii::app()->db->createCommand($sql)->queryAll();
//                ->select('uni_ref_id, course_name, course_id, department_name AS sub_dept_name, html_entity, admission_page_link, course_page_link, 
//                    IF((course_fees_duration_id IN(1,2,3,4,5)), course_fees_duration_id, IF((course_fees_duration_id=8)," / Year",IF((course_fees_duration_id=7)," / Semester","")))
//                     as duration, SUM(fees) AS fees, COUNT(course_id) AS fee_years, course_duration')
//                ->from('tbl_uni_courses AS uc')
//                ->join('lookup_department AS ld', 'uc.department_ref_id = ld.department_id')
//                ->leftJoin('course_fees AS cf', 'cf.`uni_course_ref_id` = uc.course_id')
//                ->leftjoin('lookup_currency AS lc', 'cf.currency_ref_id = lc.currency_id')
//                ->leftjoin('lookup_course_fees_duration AS lcfd', 'cf.course_fees_duration_ref_id = lcfd.course_fees_duration_id')
//                ->leftjoin('lookup_reservation AS lr', 'lr.reservation_id = cf.reservation_ref_id')
//                ->where("uc.is_active = 'Y' AND reservation_ref_id = 1 and uni_ref_id=:uni_id and main_dept_id=:dept_id " . $inCondition, array(':uni_id' => $uni_id, ':dept_id' => $dept_id))
//                ->group('course_id')
//                ->queryAll();
        return $departmentCourse;
    }

    public static function getCourseCountByUniversityAndCourse($uni_id, $dept_id) {

        $criteria = new CDbCriteria();
        $criteria->select = 'course_id';
        $criteria->condition = "uni_ref_id=:id and is_active = 'Y' AND department_ref_id = '$dept_id' ";
        $criteria->params = array(':id' => $uni_id);

        $criteria->addInCondition('course_level', array(6, 7));


        $count = self::model()->count($criteria);
        return $count;
    }

    public static function getCourseCountByUniversityId($uni_id, $course_level = '') {

        $criteria = new CDbCriteria();
        $criteria->select = 'department_ref_id';
        $criteria->condition = "uni_ref_id=:id and is_active = 'Y'";
        $criteria->params = array(':id' => $uni_id);

        if ($course_level == 'ug') {
            $criteria->addInCondition('course_level', array(6, 7));
        } elseif ($course_level == 'pg') {
            $criteria->addInCondition('course_level', array(2, 3, 4));
        }

        $count = self::model()->count($criteria);
        return $count;
    }

    public static function getCourseUrlData($course_id, $byCourseHash = 0) {
        $criteria = new CDbCriteria();
        $criteria->select = 'course_id, course_name, seo_keyword, url_primary_key';
        
        if($byCourseHash) {
            $criteria->condition = "t.url_primary_key=:id";
            $criteria->params = array(':id' => $course_id);
        } else {
            $criteria->condition = "course_id=:id";
            $criteria->params = array(':id' => $course_id);
        }

        $data = self::model()->with(array('uniRef'=>array('select'=>'uni_name,country_ref_id'),'uniRef.countryRef','departmentRef'=>array('select'=>'department_name')))->find($criteria);
 
        $courseUrlData['course_id'] = $data->url_primary_key;
        $courseUrlData['uni_name'] = $data->uniRef->uni_name;
        $courseUrlData['course_name'] = $data->course_name;        
        $courseUrlData['country_code'] = $data->uniRef->countryRef->country_code;
        $courseUrlData['keyword'] = $data->seo_keyword;
        $courseUrlData['department_name'] = $data->departmentRef->department_name;

        return $courseUrlData;
    }

    public static function getCourseIdFromHash($hashCourseId) {
        $criteria = new CDbCriteria();
        $criteria->select = 'course_id, t.url_primary_key, course_name, is_active,uni_ref_id,department_ref_id';
        $criteria->condition = "t.url_primary_key=:id";
        $criteria->params = array(':id' => $hashCourseId);

        $data = self::model()->with(array('uniRef'=>array('select'=>'uni_name')))->find($criteria);

        $courseUrl['course_id'] = $data->course_id;
        $courseUrl['url_primary_key'] = $data->url_primary_key;
        $courseUrl['course_name'] = $data->course_name;
        $courseUrl['uni_name'] = $data->uniRef->uni_name;
        $courseUrl['uni_id'] = $data->uni_ref_id;
        $courseUrl['is_active'] = $data->is_active;
        $courseUrl['department_ref_id'] = $data->department_ref_id;

        return $courseUrl;
    }

    /**
     * This method will return the course data with specified columns
     * @param int $id     
     * @param string $columns (optional)
     * @return array
     */
    public static function getCourseAttributeById($id, $columns = '') {
        $criteria = new CDbCriteria();
        if (strlen($columns)) {
            $criteria->select = $columns;
        } else {
            $criteria->select = '*';
        }

        $criteria->condition = 'course_id=:id';
        $criteria->params = array(':id' => $id);
        $data = self::model()->find($criteria);
        return $data;
    }

    public static function getCourseHeaderData($courseId) {
        $criteria = new CDbCriteria();
        $criteria->select = 'course_page_link';
        $criteria->condition = "course_id=:id";
        $criteria->params = array(':id' => $courseId);

        $data = self::model()->with('uniRef')->with('degreeGrantedRef')->find($criteria);

        $courseUrlData['uni_id'] = $data->uniRef->uni_id;
        $courseUrlData['uni_name'] = $data->uniRef->uni_name;
        $courseUrlData['degree_granted'] = $data->degreeGrantedRef->degree_name;
        $courseUrlData['course_page_link'] = $data->course_page_link;
        $data = self::getMainDepartmentNameByCourseId($courseId);
        $courseUrlData['main_department_name'] = $data['main_dept_name'];
        $courseUrlData['department_name'] = $data['dept_name'];
        
        return $courseUrlData;
    }

    public static function getMainDepartmentNameByCourseId($courseId) {
        
        $mainDepartment = Yii::app()->db->createCommand()
                ->select('ld.department_name as dept_name, ld_main.department_name as main_dept_name')
                ->from('tbl_uni_courses AS uc')
                ->join('lookup_department AS ld', 'uc.department_ref_id = ld.department_id')
                ->join('lookup_department AS ld_main', 'ld_main.department_id = ld.main_dept_id')
                ->where("course_id=:id", array(':id' => $courseId))
                ->queryRow();
        return $mainDepartment;
    }

    public static function getCourseScholarshipData($uniId, $deptId, $course_level = '') {
        
        if ($course_level == 'ug') {
            $inCondition = ' AND course_level_ref_id in (6,7)';
        } elseif ($course_level == 'pg') {
            $inCondition = ' AND course_level_ref_id in (2,3,4)';
        }
        $countryId = TblUniversityMaster::getUniCountryName($uniId);
        $scholarshipData = Yii::app()->db->createCommand()
                ->selectDistinct('shi.uni_ref_id, scholarship_id, sub_dept_ref_id, html_entity, currency_code, scholarship_name, frequency, scholarship_provider_name, amount, currency_ref_id')
                ->from('scholarship AS s')
                ->join('scholarship_department AS sd', 's.scholarship_id = sd.scholarship_ref_id')
                ->join('scholarship_host_institute AS shi', 's.scholarship_id = shi.scholarship_ref_id')
                ->join('tbl_uni_courses AS tc', 'tc.department_ref_id = sd.sub_dept_ref_id')                
                ->leftJoin('lookup_currency as lc', 'lc.currency_id = s.currency_ref_id')                
                ->where("((shi.uni_ref_id=:uniId AND shi.country_ref_id =:countryId) OR (shi.uni_ref_id IS NULL AND shi.country_ref_id =:countryId)) AND s.is_active = 1 AND tc.department_ref_id=:deptId".$inCondition, array(':uniId' => $uniId, ':deptId'=>$deptId, 'countryId' => $countryId))
                ->order('amount desc')
                ->queryAll();
        return $scholarshipData;
    }
    
    public static function getIntakeDateByCourseId($courseId) {
        
        $intakeMonth = Yii::app()->db->createCommand()
                ->select('month')
                ->from('course_start_date')
                ->where("uni_course_ref_id=:id", array(':id' => $courseId))
                ->queryAll();
        return $intakeMonth;
    }
    
    public static function getUniversityMainDeptList($uniId, $onlyUG = false){

        $inCondition = $onlyUG ? ' AND uc.course_level in (6,7)' : '';
        $mainDepartment = Yii::app()->db->createCommand()
            ->select('ld_main.department_id, ld_main.department_name')
            ->from('tbl_uni_courses AS uc')
            ->join('lookup_department AS ld', 'uc.department_ref_id = ld.department_id')
            ->join('lookup_department AS ld_main', 'ld_main.department_id = ld.main_dept_id')
            ->where("uni_ref_id=:id and uc.is_active = 'Y' $inCondition", array(':id' => $uniId))
            ->group('ld_main.department_id')
            ->queryAll();
        return $mainDepartment;
    }

    public static function getAllCoursesByDepartmentByCountry($deptId=0, $countryId = 0, $limit = 0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->join = "LEFT JOIN tbl_university_master um ON um.uni_id = t.uni_ref_id";
        $cdbCriteria->addCondition("t.is_active = 'Y'", "AND");
        $cdbCriteria->addCondition("t.department_ref_id = ".$deptId, "AND");
        if($countryId > 0){
            $cdbCriteria->addCondition("um.country_ref_id = ".$countryId, "AND");
        }
        if($limit > 0){
            $cdbCriteria->limit = $limit;
        }
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getAllCoursesByUniversityByDepartmentByCourseLevel($uniId=0, $deptId=0, $courseLevel=0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("t.uni_ref_id = ".$uniId, "AND");
        $cdbCriteria->addCondition("t.department_ref_id = ".$deptId, "AND");
        $cdbCriteria->addCondition("t.course_level = ".$courseLevel, "AND");
        $cdbCriteria->addCondition("t.is_active = 'Y'", "AND");
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }


    public static function getAllCoursesByUniversityByDepartmentByCourseLevel_v1(){
        $sql = "SELECT um.uni_id, ld.department_id, cl.level_id , um.country_ref_id, uc.course_duration
                FROM tbl_uni_courses uc
                JOIN course_fees cf ON cf.uni_course_ref_id = uc.course_id
                JOIN lookup_reservation lr ON lr.reservation_id = cf.reservation_ref_id
                JOIN lookup_course_level cl ON cl.level_id = uc.course_level
                JOIN lookup_department ld ON ld.department_id = uc.department_ref_id
                JOIN tbl_university_master um ON um.uni_id = uc.uni_ref_id
                WHERE 1=1
                AND um.is_active = 'Y'
                AND  uc.is_active = 'Y'
                AND cl.is_active = 'Y'
                AND ld.is_active = 'Y'
                AND uc.course_duration > 0
                AND cf.fees > 0
                AND (lr.reservation_name = 'General Category' OR lr.reservation_name = 'International Student')
                GROUP BY um.uni_id, ld.department_id, cl.level_id
                ORDER BY um.uni_id, ld.department_id";
        $overallCourses = Yii::app()->db->createCommand($sql);
        $res = $overallCourses->queryAll();
        return $res;
    }

    public static function getAvgFeesPerYear($uni_id) {
        /* $criteria = new CDbCriteria();
        $criteria->select = 'AVG(fees) as fees';
        $criteria->join = 'LEFT JOIN course_fees cf ON cf.uni_course_ref_id = t.course_id';
        $criteria->condition = 'uni_ref_id=:id';
        $criteria->params = array(':id' => $uni_id);
        $data = self::model()->find($criteria);
        return $data; */
        $sql = "SELECT AVG(cf.fees) AS fees FROM tbl_uni_courses uc
                LEFT JOIN course_fees cf ON cf.uni_course_ref_id = uc.course_id
                WHERE uni_ref_id = '".$uni_id."' AND uc.is_active='Y' AND uc.course_level = 6";
        $coursefees = Yii::app()->db->createCommand($sql);
        $res = $coursefees->queryRow();
        return $res['fees'];
    }

    public static function getCourseListAuto($searchTerm, $uniId,$limit = 20) {

        $criteria = new CDbCriteria;
        $criteria->select = 'c.course_id,c.course_name';
        $criteria->alias = 'c';
        $criteria->join = 'JOIN university_course_date_description cd ON c.course_id=cd.course_ref_id ';

        if ($searchTerm) {
            $criteria->condition = "c.course_name LIKE '%$searchTerm%' AND c.uni_ref_id='$uniId' AND is_active='Y'";
        }

        $criteria->group = 'c.course_id';
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN c.course_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), c.course_name";
        $criteria->limit = $limit;

        $res = self::model()->findAll($criteria);
        return $res;
    }

    public static function getCoursesByUniId($universityId,$courseLevel=6){
        $sql="SELECT ct.course_id, ct.course_name
        FROM tbl_uni_courses ct
        JOIN university_course_date_description dd ON ct.course_id=dd.course_ref_id
        WHERE ct.uni_ref_id=".$universityId."
        AND ct.course_level=6 AND ct.is_active='Y'
        GROUP BY ct.course_id
        UNION ALL
        SELECT u.uni_course_ref_id,uc.course_name
        FROM `entrance_exam` e
        JOIN uni_course_test u ON e.entrance_id=u.entrance_ref_id
        JOIN  tbl_uni_courses ct ON ct.course_id = u.uni_course_ref_id
        JOIN tbl_uni_courses uc ON uc.course_id=u.uni_course_ref_id
        JOIN entrance_exam_date_section es ON e.entrance_id=es.entrance_exam_ref_id
        WHERE u.uni_ref_id=".$universityId." AND e.entrance_short_name NOT IN('Admission Based on Cut Offs','None') AND e.is_active=1 AND ct.is_active='Y'
        GROUP BY u.uni_course_ref_id
        ORDER BY course_name ASC";
        $cmd = Yii::app()->db->createCommand($sql);
        $courseData=$cmd->queryAll();
        $courses = array();
         foreach($courseData as $row)
         {
             $courses[$row['course_id']] = $row['course_name'];
         }
        return $courses;
    }

    public static function getFirstCourseNameByUniId($universityId,$courseLevel=6){
        $sql="SELECT ct.course_id, ct.course_name
        FROM tbl_uni_courses ct
        JOIN university_course_date_description dd ON ct.course_id=dd.course_ref_id
        WHERE ct.uni_ref_id=".$universityId."
        AND ct.course_level=6 AND ct.is_active='Y'
        GROUP BY ct.course_id
        UNION ALL
        SELECT u.uni_course_ref_id,uc.course_name
        FROM `entrance_exam` e
        JOIN uni_course_test u ON e.entrance_id=u.entrance_ref_id
        JOIN  tbl_uni_courses ct ON ct.course_id = u.uni_course_ref_id
        JOIN tbl_uni_courses uc ON uc.course_id=u.uni_course_ref_id
        JOIN entrance_exam_date_section es ON e.entrance_id=es.entrance_exam_ref_id
        WHERE u.uni_ref_id=".$universityId." AND e.entrance_short_name NOT IN('Admission Based on Cut Offs','None') AND e.is_active=1 AND ct.is_active='Y'
        GROUP BY u.uni_course_ref_id
        ORDER BY course_name ASC LIMIT 1";
        $cmd = Yii::app()->db->createCommand($sql);
        $courseData=$cmd->queryAll();
       // $courses = array();
        foreach($courseData as $row)
        {
            $courses[$row['course_id']] = $row['course_name'];
        }
        return $courseData;
    }


    public static function getAvgFeeOfCollegeByIdAndDept($uid,$did){
        $sql = 'SELECT
                cf.currency_ref_id,
                 AVG(fees) AS fees_per_year
                FROM `tbl_uni_courses` t
                LEFT JOIN lookup_department ld ON ld.department_id = t.department_ref_id
                JOIN course_fees cf ON t.course_id = cf.uni_course_ref_id
                WHERE t.uni_ref_id = '.$uid.' AND  main_dept_id = '.$did.' AND t.is_active = "Y"';
      
        $cmd = Yii::app()->db->createCommand($sql);

        $result=$cmd->queryAll();

        return $result;
    }

    public static function getAvgFeeOfCollegeById($uid){
        $sql = 'SELECT
                cf.currency_ref_id,
                 AVG(fees) AS fees_per_year
                FROM `tbl_uni_courses` t
                LEFT JOIN lookup_department ld ON ld.department_id = t.department_ref_id
                JOIN course_fees cf ON t.course_id = cf.uni_course_ref_id
                WHERE t.uni_ref_id = '.$uid.' AND t.is_active = "Y" ';

        $cmd = Yii::app()->db->createCommand($sql);

        $result=$cmd->queryAll();

        return $result;
    }

    public static function getCoursesBySubDept($uId, $subDept, $limit=false){

        $condition = '';
        if(!is_array($subDept)) $subDept = array($subDept);
        $subDeptIds = implode(',', $subDept);
        $condition = " AND tuc.department_ref_id IN ($subDeptIds)";

        $sql = "SELECT course_id,course_name
                FROM tbl_uni_courses tuc
                WHERE tuc.uni_ref_id = $uId
                $condition
                AND tuc.course_level = 6 AND tuc.is_active = 'Y' ";

        if($limit) {
            $sql.= " LIMIT 4";
        }

        $cmd = Yii::app()->db->createCommand($sql);

        $result=$cmd->queryAll();

        return $result;
    }

    public static function getAllCourses($searchTerm, $limit = 20, $uni_ref_id = false){

        $searchTerm = mysql_escape_string($searchTerm);
        $criteria = new CDbCriteria;
        $criteria->select = array('course_id', 'course_name', 'url_primary_key');

        $criteria->condition = "(course_name LIKE '%$searchTerm%') AND is_active = 'Y' AND uni_ref_id =".$uni_ref_id;

        $criteria->group = 'course_id';
      //  $criteria->order = "(CASE WHEN course_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), course_name";
        $criteria->limit = $limit;

        $res = self::model()->findAll($criteria);
        return $res;
    }

    public static function getCourseSet($limit, $offset){
        $criteria = new CDbCriteria();
        $criteria->select = 't.course_id, t.course_name,t.uni_ref_id';
        $criteria->join = 'JOIN tbl_university_master um ON um.uni_id = t.uni_ref_id';
        $criteria->condition = "t.is_active ='Y' AND um.is_active = 'Y' AND um.url_primary_key != '' AND um.is_user_entered = '0'";
        $criteria->limit ="$limit";
        $criteria->offset= "$offset";
        $data = TblUniCourses::model()->findAll($criteria);
        return $data;
    }
}
