<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseTblUserInterest');

class TblUserInterest extends BaseTblUserInterest
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
 
    public function behaviors(){
        return array(
            'StudentActivityFeedBehavior' => 'application.behaviors.StudentActivityFeedBehavior',
        );
    }        

    public function StudentActivityFeedLoggableAttributes(){
        return array(
            'user_interest_ref_id, user_interest_type_ref_id, user_interest_level_ref_id, interest_level, interest_type, interest_hobbies, awards_achievements, voluntary_work' => 'extra_curricular',
        );
    }
  
	public static function saveIntestsHobbies($postdata) {
		/* 
		 *  Save method for user data
		 */
		$model = new TblUserInterest;
		$userId = Profile::getUserId();
			
		$model->attributes=$_POST['TblUserInterest'];
		$model->setAttribute('user_ref_id',$userId);
		$model->setAttribute('added_on',date('Y-m-d H:i:s'));
		 
		if(!empty($model->interest_hobbies)){
				$models2Delete = TblUserInterest::model()->findAll(array('condition'=>'user_ref_id ='.$userId));
				 
				foreach($models2Delete as $m) {
					//delete existing preferences
					$m->delete();
				}
				if(!($model->validate() && $model->save()))
				{						 
					throw new CHttpException(400, 'Invalid request. Please check and ensure that you have provided all valid inputs.');					
				} else {
					// critical counter update here
					Yii::app()->getController()->profileCriticalCompletion('interest', '1', $userId);
					Yii::app()->user->setFlash('Success','Interests saved !');
					Yii::app()->getController()->redirect(Yii::app()->getController()->createUrl('profile/ask-questions'));
				}
		} else {
			Yii::app()->user->setFlash('error','Invalid data, Please type your interests and hobbies !');

		}
		//die();
		 
		
	}

    public static function getUserInterests($userId) {
        $sql ="SELECT user_interest_type_ref_id, user_interest_level_ref_id, lui.interest FROM tbl_user_interest t
                    INNER JOIN lookup_user_interest lui ON lui.user_interest_id = t.user_interest_ref_id
                    WHERE t.user_ref_id = :userID";
        $command =Yii::app()->db->createCommand($sql);
        $command->bindValue(":userID", $userId, PDO::PARAM_INT);
        $res =$command->queryAll();
        return $res;
    }
    
    public static function getUserInterestsByInterestId($userId, $interestId){
        $cdbCriteria = new CDbCriteria();
       // $cdbCriteria->with = array('loginRef');
        $cdbCriteria->condition = "user_ref_id=".$userId." AND user_interest_ref_id=".$interestId;
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }
    
    public static function getUserInterestsByUid($userId){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 'user_interest_type_ref_id';
        $cdbCriteria->with = 'userInterestTypeRef';
        $cdbCriteria->condition = "user_ref_id=".$userId." ";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }    
	
}