<?php

/*
 * @author Shastry Chamarthi
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseTblUserProfCriticalCompletion');

class TblUserProfCriticalCompletion extends BaseTblUserProfCriticalCompletion
{
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public static function createCriticalField($userId = false)
    {
        if (!$userId) {
            $userId = Profile::getUserId();
        }
        $criticalFieldModel = new TblUserProfCriticalCompletion;
        $criticalFieldModel->edu_study_level = '1';
        $criticalFieldModel->name = '1';
        $criticalFieldModel->user_ref_id = $userId;
        $criticalFieldModel->save();
    }

    /*
     * This function is to update user critical fields
     * input array should not contain user_id
     */
    public static function updateCriticalFields($userId, $criticalFields=array()){
        $criticalFieldModel = self::model()->findAllByPk($userId);
        if(!$criticalFieldModel){
            $criticalFieldModel = new TblUserProfCriticalCompletion();
            $criticalFieldModel->setAttributes($criticalFields);
            $criticalFieldModel->user_ref_id = $userId;
            $criticalFieldModel->save(false);
        }else{
            $criticalFieldModel = new TblUserProfCriticalCompletion();
            $criticalFieldModel->updateByPk($userId, $criticalFields);
        }
        /*$userCriticalPercentage = new TblUserProfCriticalCompletion();
        $userCriticalPercentage->setAttributes($criticalFields);
        die('<br>'.print_r($userCriticalPercentage->attributes));
        $userCriticalPercentage->save(false);*/

    }
	
    public static function getUserCriticalField($userId=0, $criticalFields=array()){
        $userCriticalFields = array();
        $model = self::model()->find("user_ref_id ='".$userId."' ");
        return $model->attributes;
    }
    
    public static function getUserCriticalFieldata($userId=1){
        
        $criteria = new CDbCriteria;
        $criteria->addCondition("user_ref_id = '" . $userId. "'", "AND");       
        $res = self::model()->find($criteria);
        return $res;
    }

    /*
     * This function returns an Url of edit profile which student missed any critical field to update
     */
    public static function getUserMissedCriticalField($userId=0, $controllerActionId = ''){
        if($controllerActionId != ''){
            $controllerActionId = strtolower($controllerActionId);
        }

        $urls = array(
            'editbasicinfo' => Yii::app()->createUrl('student/profile/EditBasicInfo'),
            'editeducation' => Yii::app()->createUrl('student/profile/EditEducation'),
            'editpreferences' => Yii::app()->createUrl('student/profile/EditPreferences'),
        );
        $criticalFields = array(
            'editbasicinfo' => array('name', 'gender', 'dob', 'citizenship', 'phone'),
            'editeducation' => array('edu_study_level', 'school_name', 'completion_year', 'board'),
            'editpreferences' => array('study_level', 'preferred_course_duration', 'country', 'intended_subjects', 'likely_start_period'),
        );

        if(Yii::app()->session->itemAt('studentProfileConfirmationId')){
            $criticalFields = array(
                'editeducation' => array('edu_study_level', 'school_name', 'completion_year', 'board'),
                'editpreferences' => array('study_level', 'preferred_course_duration', 'country', 'intended_subjects', 'likely_start_period'),
            );
        }

        $redirectUrl = array();
        $missedCriticalFields = array();

        $userCriticalFields = self::getUserCriticalField($userId);
        foreach($criticalFields as $module => $fieldsArray){
            foreach($fieldsArray as $field){
                if(!$userCriticalFields[$field]){
                    $missedCriticalFields[] = $field;
                    $redirectUrl[] = $urls[$module].'#'.$field;
                }
            }
            /*if(count($missedCriticalFields) > 0){
                break;
            }*/
        }

        if($controllerActionId != ''){
            return $redirectUrl[0];
        }else{
            return $missedCriticalFields;
        }
    }
        
}