<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseConfirmationEmailTracker is autogenerate by UniModel generator
 *
 * This is the model class for table "confirmation_email_tracker".
 *
 * The followings are the available columns in table 'confirmation_email_tracker':
 * @property string $confirmation_email_tracker_id
 * @property string $user_ref_id
 * @property string $added_on
 * @property string $opened_on
 * @property string $clicked
 * @property string $clicked_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseConfirmationEmailTracker extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ConfirmationEmailTracker the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'confirmation_email_tracker';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'required'),
			array('user_ref_id', 'length', 'max'=>10),
			array('clicked', 'length', 'max'=>1),
			array('added_on, opened_on, clicked_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('confirmation_email_tracker_id, user_ref_id, added_on, opened_on, clicked, clicked_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'confirmation_email_tracker_id' => 'Confirmation Email Tracker',
			'user_ref_id' => 'User Ref',
			'added_on' => 'Added On',
			'opened_on' => 'Opened On',
			'clicked' => 'Clicked',
			'clicked_on' => 'Clicked On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('confirmation_email_tracker_id',$this->confirmation_email_tracker_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('opened_on',$this->opened_on,true);
		$criteria->compare('clicked',$this->clicked,true);
		$criteria->compare('clicked_on',$this->clicked_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}