<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseCriteriaLocation is autogenerate by UniModel generator
 *
 * This is the model class for table "criteria_location".
 *
 * The followings are the available columns in table 'criteria_location':
 * @property integer $criteria_location_id
 * @property integer $country_ref_id
 * @property integer $city_ref_id
 * @property string $type
 * @property string $type_id
 * @property integer $invitation_number
 * @property integer $is_all
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property TblCityMaster $cityRef
 * @property TblCountryMaster $countryRef
 */
class BaseCriteriaLocation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CriteriaLocation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'criteria_location';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('country_ref_id, city_ref_id, type_id, added_by, added_on', 'required'),
			array('country_ref_id, city_ref_id, invitation_number, is_all', 'numerical', 'integerOnly'=>true),
			array('type', 'length', 'max'=>9),
			array('type_id, added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('criteria_location_id, country_ref_id, city_ref_id, type, type_id, invitation_number, is_all, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'criteria_location_id' => 'Criteria Location',
			'country_ref_id' => 'Country Ref',
			'city_ref_id' => 'City Ref',
			'type' => 'Type',
			'type_id' => 'Type',
			'invitation_number' => 'Invitation Number',
			'is_all' => 'Is All',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('criteria_location_id',$this->criteria_location_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('type_id',$this->type_id,true);
		$criteria->compare('invitation_number',$this->invitation_number);
		$criteria->compare('is_all',$this->is_all);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}