<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiBannerCampaignTargetCity is autogenerate by UniModel generator
 *
 * This is the model class for table "di_banner_campaign_target_city".
 *
 * The followings are the available columns in table 'di_banner_campaign_target_city':
 * @property string $target_city_id
 * @property integer $banner_campaign_ref_id
 * @property integer $city_ref_id
 *
 * The followings are the available model relations:
 * @property DiBannerCampaign $bannerCampaignRef
 * @property TblCityMaster $cityRef
 */
class BaseDiBannerCampaignTargetCity extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiBannerCampaignTargetCity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_banner_campaign_target_city';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('banner_campaign_ref_id, city_ref_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('target_city_id, banner_campaign_ref_id, city_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'bannerCampaignRef' => array(self::BELONGS_TO, 'DiBannerCampaign', 'banner_campaign_ref_id'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'target_city_id' => 'Target City',
			'banner_campaign_ref_id' => 'Banner Campaign Ref',
			'city_ref_id' => 'City Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('target_city_id',$this->target_city_id,true);
		$criteria->compare('banner_campaign_ref_id',$this->banner_campaign_ref_id);
		$criteria->compare('city_ref_id',$this->city_ref_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}