<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiOnboardEmailTrack is autogenerate by UniModel generator
 *
 * This is the model class for table "di_onboard_email_track".
 *
 * The followings are the available columns in table 'di_onboard_email_track':
 * @property string $di_onboard_email_track_id
 * @property string $user_ref_id
 * @property integer $country_ref_id
 * @property integer $slab
 * @property string $email_message_ref_id
 * @property string $sent_on
 * @property string $mail_opened_on
 * @property string $is_link_opened
 * @property string $is_confirmed
 * @property string $engagement_emails_ref_id
 * @property string $link_opened_on
 *
 * The followings are the available model relations:
 * @property TblCountryMaster $countryRef
 * @property EmailMessage $emailMessageRef
 * @property EngagementEmails $engagementEmailsRef
 * @property TblUserMaster $userRef
 * @property DiOnboardUniversityShortlist[] $diOnboardUniversityShortlists
 */
class BaseDiOnboardEmailTrack extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiOnboardEmailTrack the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_onboard_email_track';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('country_ref_id, slab', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, email_message_ref_id, engagement_emails_ref_id', 'length', 'max'=>10),
			array('is_link_opened, is_confirmed', 'length', 'max'=>1),
			array('sent_on, mail_opened_on, link_opened_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_onboard_email_track_id, user_ref_id, country_ref_id, slab, email_message_ref_id, sent_on, mail_opened_on, is_link_opened, is_confirmed, engagement_emails_ref_id, link_opened_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'emailMessageRef' => array(self::BELONGS_TO, 'EmailMessage', 'email_message_ref_id'),
			'engagementEmailsRef' => array(self::BELONGS_TO, 'EngagementEmails', 'engagement_emails_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'diOnboardUniversityShortlists' => array(self::HAS_MANY, 'DiOnboardUniversityShortlist', 'di_onboard_email_track_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_onboard_email_track_id' => 'Di Onboard Email Track',
			'user_ref_id' => 'User Ref',
			'country_ref_id' => 'Country Ref',
			'slab' => 'Slab',
			'email_message_ref_id' => 'Email Message Ref',
			'sent_on' => 'Sent On',
			'mail_opened_on' => 'Mail Opened On',
			'is_link_opened' => 'Is Link Opened',
			'is_confirmed' => 'Is Confirmed',
			'engagement_emails_ref_id' => 'Engagement Emails Ref',
			'link_opened_on' => 'Link Opened On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_onboard_email_track_id',$this->di_onboard_email_track_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('slab',$this->slab);
		$criteria->compare('email_message_ref_id',$this->email_message_ref_id,true);
		$criteria->compare('sent_on',$this->sent_on,true);
		$criteria->compare('mail_opened_on',$this->mail_opened_on,true);
		$criteria->compare('is_link_opened',$this->is_link_opened,true);
		$criteria->compare('is_confirmed',$this->is_confirmed,true);
		$criteria->compare('engagement_emails_ref_id',$this->engagement_emails_ref_id,true);
		$criteria->compare('link_opened_on',$this->link_opened_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}