<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailUnsubscribe is autogenerate by UniModel generator
 *
 * This is the model class for table "email_unsubscribe".
 *
 * The followings are the available columns in table 'email_unsubscribe':
 * @property string $email_unsubscribe_id
 * @property string $email_id
 * @property string $category
 * @property string $added_on
 */
class BaseEmailUnsubscribe extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailUnsubscribe the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'email_unsubscribe';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('email_id', 'required'),
			array('email_id', 'length', 'max'=>100),
			array('category', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('email_unsubscribe_id, email_id, category, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'email_unsubscribe_id' => 'Email Unsubscribe',
			'email_id' => 'Email',
			'category' => 'Category',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('email_unsubscribe_id',$this->email_unsubscribe_id,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('category',$this->category,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}