<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailerKnowledgeTracker is autogenerate by UniModel generator
 *
 * This is the model class for table "emailer_knowledge_tracker".
 *
 * The followings are the available columns in table 'emailer_knowledge_tracker':
 * @property string $emailer_knowledge_tracker_id
 * @property integer $emailer_knowledge_template_ref_id
 * @property integer $emailer_knowledge_template_map_ref_id
 * @property string $user_ref_id
 * @property string $email_recipient_ref_id
 * @property integer $week_number
 * @property string $sent_on
 * @property string $opened_on
 *
 * The followings are the available model relations:
 * @property EmailerKnowledgeTemplate $emailerKnowledgeTemplateRef
 * @property EmailRecipient $emailRecipientRef
 * @property TblUserMaster $userRef
 */
class BaseEmailerKnowledgeTracker extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailerKnowledgeTracker the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'emailer_knowledge_tracker';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('emailer_knowledge_template_ref_id, user_ref_id, email_recipient_ref_id, week_number, sent_on', 'required'),
			array('emailer_knowledge_template_ref_id, emailer_knowledge_template_map_ref_id, week_number', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, email_recipient_ref_id', 'length', 'max'=>10),
			array('opened_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('emailer_knowledge_tracker_id, emailer_knowledge_template_ref_id, emailer_knowledge_template_map_ref_id, user_ref_id, email_recipient_ref_id, week_number, sent_on, opened_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emailerKnowledgeTemplateRef' => array(self::BELONGS_TO, 'EmailerKnowledgeTemplate', 'emailer_knowledge_template_ref_id'),
			'emailRecipientRef' => array(self::BELONGS_TO, 'EmailRecipient', 'email_recipient_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'emailer_knowledge_tracker_id' => 'Emailer Knowledge Tracker',
			'emailer_knowledge_template_ref_id' => 'Emailer Knowledge Template Ref',
			'emailer_knowledge_template_map_ref_id' => 'Emailer Knowledge Template Map Ref',
			'user_ref_id' => 'User Ref',
			'email_recipient_ref_id' => 'Email Recipient Ref',
			'week_number' => 'Week Number',
			'sent_on' => 'Sent On',
			'opened_on' => 'Opened On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('emailer_knowledge_tracker_id',$this->emailer_knowledge_tracker_id,true);
		$criteria->compare('emailer_knowledge_template_ref_id',$this->emailer_knowledge_template_ref_id);
		$criteria->compare('emailer_knowledge_template_map_ref_id',$this->emailer_knowledge_template_map_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('email_recipient_ref_id',$this->email_recipient_ref_id,true);
		$criteria->compare('week_number',$this->week_number);
		$criteria->compare('sent_on',$this->sent_on,true);
		$criteria->compare('opened_on',$this->opened_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}