<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseGemLeadProspect is autogenerate by UniModel generator
 *
 * This is the model class for table "gem_lead_prospect".
 *
 * The followings are the available columns in table 'gem_lead_prospect':
 * @property string $gem_lead_prospect_id
 * @property integer $advisor_ref_id
 * @property string $gem_lead_ref_id
 * @property integer $prospect_category_ref_id
 * @property integer $short_list_advisor_ref_id
 * @property string $status_reason
 * @property string $assigned_date
 * @property string $decision_date
 * @property integer $reassigned_from
 * @property string $reassigned_date
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property TblAdmin $shortListAdvisorRef
 * @property TblAdmin $advisorRef
 * @property LoginMaster $addedBy
 * @property GemLead $gemLeadRef
 * @property LoginMaster $modifiedBy
 * @property LookupProspectCategory $prospectCategoryRef
 * @property TblAdmin $reassignedFrom
 * @property GemLeadProspectInteraction[] $gemLeadProspectInteractions
 */
class BaseGemLeadProspect extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GemLeadProspect the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'gem_lead_prospect';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('gem_lead_ref_id, prospect_category_ref_id', 'required'),
			array('advisor_ref_id, prospect_category_ref_id, short_list_advisor_ref_id, reassigned_from', 'numerical', 'integerOnly'=>true),
			array('gem_lead_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('status_reason', 'length', 'max'=>255),
			array('assigned_date, decision_date, reassigned_date, added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('gem_lead_prospect_id, advisor_ref_id, gem_lead_ref_id, prospect_category_ref_id, short_list_advisor_ref_id, status_reason, assigned_date, decision_date, reassigned_from, reassigned_date, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'shortListAdvisorRef' => array(self::BELONGS_TO, 'TblAdmin', 'short_list_advisor_ref_id'),
			'advisorRef' => array(self::BELONGS_TO, 'TblAdmin', 'advisor_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'gemLeadRef' => array(self::BELONGS_TO, 'GemLead', 'gem_lead_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'prospectCategoryRef' => array(self::BELONGS_TO, 'LookupProspectCategory', 'prospect_category_ref_id'),
			'reassignedFrom' => array(self::BELONGS_TO, 'TblAdmin', 'reassigned_from'),
			'gemLeadProspectInteractions' => array(self::HAS_MANY, 'GemLeadProspectInteraction', 'gem_lead_prospect_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'gem_lead_prospect_id' => 'Gem Lead Prospect',
			'advisor_ref_id' => 'Advisor Ref',
			'gem_lead_ref_id' => 'Gem Lead Ref',
			'prospect_category_ref_id' => 'Prospect Category Ref',
			'short_list_advisor_ref_id' => 'Short List Advisor Ref',
			'status_reason' => 'Status Reason',
			'assigned_date' => 'Assigned Date',
			'decision_date' => 'Decision Date',
			'reassigned_from' => 'Reassigned From',
			'reassigned_date' => 'Reassigned Date',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('gem_lead_prospect_id',$this->gem_lead_prospect_id,true);
		$criteria->compare('advisor_ref_id',$this->advisor_ref_id);
		$criteria->compare('gem_lead_ref_id',$this->gem_lead_ref_id,true);
		$criteria->compare('prospect_category_ref_id',$this->prospect_category_ref_id);
		$criteria->compare('short_list_advisor_ref_id',$this->short_list_advisor_ref_id);
		$criteria->compare('status_reason',$this->status_reason,true);
		$criteria->compare('assigned_date',$this->assigned_date,true);
		$criteria->compare('decision_date',$this->decision_date,true);
		$criteria->compare('reassigned_from',$this->reassigned_from);
		$criteria->compare('reassigned_date',$this->reassigned_date,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}