<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLoginLog is autogenerate by UniModel generator
 *
 * This is the model class for table "login_log".
 *
 * The followings are the available columns in table 'login_log':
 * @property string $login_log_id
 * @property string $login_ref_id
 * @property string $ip_address
 * @property string $login_status
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $loginRef
 */
class BaseLoginLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LoginLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'login_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('login_ref_id, added_on', 'required'),
			array('login_ref_id', 'length', 'max'=>10),
			array('ip_address', 'length', 'max'=>16),
			array('login_status', 'length', 'max'=>7),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('login_log_id, login_ref_id, ip_address, login_status, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'login_log_id' => 'Login Log',
			'login_ref_id' => 'Login Ref',
			'ip_address' => 'Ip Address',
			'login_status' => 'Login Status',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('login_log_id',$this->login_log_id,true);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('ip_address',$this->ip_address,true);
		$criteria->compare('login_status',$this->login_status,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}