<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupEntrance is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_entrance".
 *
 * The followings are the available columns in table 'lookup_entrance':
 * @property integer $entrance_id
 * @property string $entrance_short_name
 * @property string $entrance_full_name
 * @property string $type_of_exam
 * @property string $kind_of_exam
 * @property string $application_availability
 * @property string $application_fees
 * @property string $application_deadline
 * @property string $exam_date
 * @property string $eligibility
 * @property string $website
 * @property string $exam_pattern
 * @property string $preparation_time
 * @property string $coaching_required
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property MdmNewUniCourseTest[] $mdmNewUniCourseTests
 * @property UniCourseTest[] $uniCourseTests
 */
class BaseLookupEntrance extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupEntrance the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_short_name, kind_of_exam', 'length', 'max'=>50),
			array('entrance_full_name, website, preparation_time', 'length', 'max'=>255),
			array('type_of_exam, application_availability, application_fees, application_deadline', 'length', 'max'=>100),
			array('exam_date, coaching_required', 'length', 'max'=>45),
			array('eligibility, exam_pattern, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_id, entrance_short_name, entrance_full_name, type_of_exam, kind_of_exam, application_availability, application_fees, application_deadline, exam_date, eligibility, website, exam_pattern, preparation_time, coaching_required, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'mdmNewUniCourseTests' => array(self::HAS_MANY, 'MdmNewUniCourseTest', 'entrance_ref_id'),
			'uniCourseTests' => array(self::HAS_MANY, 'UniCourseTest', 'entrance_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_id' => 'Entrance',
			'entrance_short_name' => 'Entrance Short Name',
			'entrance_full_name' => 'Entrance Full Name',
			'type_of_exam' => 'Type Of Exam',
			'kind_of_exam' => 'Kind Of Exam',
			'application_availability' => 'Application Availability',
			'application_fees' => 'Application Fees',
			'application_deadline' => 'Application Deadline',
			'exam_date' => 'Exam Date',
			'eligibility' => 'Eligibility',
			'website' => 'Website',
			'exam_pattern' => 'Exam Pattern',
			'preparation_time' => 'Preparation Time',
			'coaching_required' => 'Coaching Required',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_id',$this->entrance_id);
		$criteria->compare('entrance_short_name',$this->entrance_short_name,true);
		$criteria->compare('entrance_full_name',$this->entrance_full_name,true);
		$criteria->compare('type_of_exam',$this->type_of_exam,true);
		$criteria->compare('kind_of_exam',$this->kind_of_exam,true);
		$criteria->compare('application_availability',$this->application_availability,true);
		$criteria->compare('application_fees',$this->application_fees,true);
		$criteria->compare('application_deadline',$this->application_deadline,true);
		$criteria->compare('exam_date',$this->exam_date,true);
		$criteria->compare('eligibility',$this->eligibility,true);
		$criteria->compare('website',$this->website,true);
		$criteria->compare('exam_pattern',$this->exam_pattern,true);
		$criteria->compare('preparation_time',$this->preparation_time,true);
		$criteria->compare('coaching_required',$this->coaching_required,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}
