<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupEvent is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_event".
 *
 * The followings are the available columns in table 'lookup_event':
 * @property integer $event_id
 * @property integer $template_mail_ref_id
 * @property string $email_type_ref_id
 * @property integer $workshop_master_ref_id
 * @property string $event_name
 * @property integer $alert_duration
 * @property string $type
 * @property string $sql_query
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property EventSi[] $eventSis
 * @property EmailType $emailTypeRef
 * @property TemplateMail $templateMailRef
 * @property WorkshopMaster $workshopMasterRef
 */
class BaseLookupEvent extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupEvent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_event';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('template_mail_ref_id', 'required'),
			array('template_mail_ref_id, workshop_master_ref_id, alert_duration, is_active', 'numerical', 'integerOnly'=>true),
			array('email_type_ref_id', 'length', 'max'=>10),
			array('event_name', 'length', 'max'=>255),
			array('type', 'length', 'max'=>4),
			array('sql_query, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('event_id, template_mail_ref_id, email_type_ref_id, workshop_master_ref_id, event_name, alert_duration, type, sql_query, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventSis' => array(self::HAS_MANY, 'EventSi', 'event_ref_id'),
			'emailTypeRef' => array(self::BELONGS_TO, 'EmailType', 'email_type_ref_id'),
			'templateMailRef' => array(self::BELONGS_TO, 'TemplateMail', 'template_mail_ref_id'),
			'workshopMasterRef' => array(self::BELONGS_TO, 'WorkshopMaster', 'workshop_master_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'event_id' => 'Event',
			'template_mail_ref_id' => 'Template Mail Ref',
			'email_type_ref_id' => 'Email Type Ref',
			'workshop_master_ref_id' => 'Workshop Master Ref',
			'event_name' => 'Event Name',
			'alert_duration' => 'Alert Duration',
			'type' => 'Type',
			'sql_query' => 'Sql Query',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('event_id',$this->event_id);
		$criteria->compare('template_mail_ref_id',$this->template_mail_ref_id);
		$criteria->compare('email_type_ref_id',$this->email_type_ref_id,true);
		$criteria->compare('workshop_master_ref_id',$this->workshop_master_ref_id);
		$criteria->compare('event_name',$this->event_name,true);
		$criteria->compare('alert_duration',$this->alert_duration);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('sql_query',$this->sql_query,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}