<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupFeedbackAnswer is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_feedback_answer".
 *
 * The followings are the available columns in table 'lookup_feedback_answer':
 * @property integer $feedback_answer_id
 * @property integer $feedback_question_ref_id
 * @property string $display_label
 * @property string $value
 * @property integer $answer_order
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupFeedbackQuestion $feedbackQuestionRef
 * @property WorkshopSiGroupFeedbackAnswer[] $workshopSiGroupFeedbackAnswers
 */
class BaseLookupFeedbackAnswer extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupFeedbackAnswer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_feedback_answer';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('feedback_question_ref_id, answer_order', 'required'),
			array('feedback_question_ref_id, answer_order, is_active', 'numerical', 'integerOnly'=>true),
			array('display_label', 'length', 'max'=>45),
			array('value', 'length', 'max'=>100),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('feedback_answer_id, feedback_question_ref_id, display_label, value, answer_order, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'feedbackQuestionRef' => array(self::BELONGS_TO, 'LookupFeedbackQuestion', 'feedback_question_ref_id'),
			'workshopSiGroupFeedbackAnswers' => array(self::HAS_MANY, 'WorkshopSiGroupFeedbackAnswer', 'feedback_answer_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'feedback_answer_id' => 'Feedback Answer',
			'feedback_question_ref_id' => 'Feedback Question Ref',
			'display_label' => 'Display Label',
			'value' => 'Value',
			'answer_order' => 'Answer Order',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('feedback_answer_id',$this->feedback_answer_id);
		$criteria->compare('feedback_question_ref_id',$this->feedback_question_ref_id);
		$criteria->compare('display_label',$this->display_label,true);
		$criteria->compare('value',$this->value,true);
		$criteria->compare('answer_order',$this->answer_order);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}