<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseProductDiscountCodeUsers is autogenerate by UniModel generator
 *
 * This is the model class for table "product_discount_code_users".
 *
 * The followings are the available columns in table 'product_discount_code_users':
 * @property string $product_discount_code_users_id
 * @property string $product_discount_code_ref_id
 * @property string $user_ref_id
 * @property string $gateway_payment_ref_id
 * @property string $used_on
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property ProductDiscountCode $productDiscountCodeRef
 * @property TblUserMaster $userRef
 * @property GatewayPayment $gatewayPaymentRef
 */
class BaseProductDiscountCodeUsers extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductDiscountCodeUsers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'product_discount_code_users';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_discount_code_ref_id, user_ref_id, gateway_payment_ref_id', 'length', 'max'=>10),
			array('used_on, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('product_discount_code_users_id, product_discount_code_ref_id, user_ref_id, gateway_payment_ref_id, used_on, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'productDiscountCodeRef' => array(self::BELONGS_TO, 'ProductDiscountCode', 'product_discount_code_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'gatewayPaymentRef' => array(self::BELONGS_TO, 'GatewayPayment', 'gateway_payment_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'product_discount_code_users_id' => 'Product Discount Code Users',
			'product_discount_code_ref_id' => 'Product Discount Code Ref',
			'user_ref_id' => 'User Ref',
			'gateway_payment_ref_id' => 'Gateway Payment Ref',
			'used_on' => 'Used On',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('product_discount_code_users_id',$this->product_discount_code_users_id,true);
		$criteria->compare('product_discount_code_ref_id',$this->product_discount_code_ref_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('gateway_payment_ref_id',$this->gateway_payment_ref_id,true);
		$criteria->compare('used_on',$this->used_on,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}