<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BasePsychometricTestCode is autogenerate by UniModel generator
 *
 * This is the model class for table "psychometric_test_code".
 *
 * The followings are the available columns in table 'psychometric_test_code':
 * @property string $psychometric_test_code_id
 * @property integer $school_ref_id
 * @property string $user_ref_id
 * @property string $gateway_payment_ref_id
 * @property string $psych_code
 * @property string $discount_amount
 * @property string $used_on
 * @property string $added_on
 * @property string $test_type
 *
 * The followings are the available model relations:
 * @property LookupSchool $schoolRef
 */
class BasePsychometricTestCode extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PsychometricTestCode the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'psychometric_test_code';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('school_ref_id, psych_code, added_on', 'required'),
			array('school_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, gateway_payment_ref_id, discount_amount', 'length', 'max'=>10),
			array('psych_code', 'length', 'max'=>100),
			array('test_type', 'length', 'max'=>2),
			array('used_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('psychometric_test_code_id, school_ref_id, user_ref_id, gateway_payment_ref_id, psych_code, discount_amount, used_on, added_on, test_type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'schoolRef' => array(self::BELONGS_TO, 'LookupSchool', 'school_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'psychometric_test_code_id' => 'Psychometric Test Code',
			'school_ref_id' => 'School Ref',
			'user_ref_id' => 'User Ref',
			'gateway_payment_ref_id' => 'Gateway Payment Ref',
			'psych_code' => 'Psych Code',
			'discount_amount' => 'Discount Amount',
			'used_on' => 'Used On',
			'added_on' => 'Added On',
			'test_type' => 'Test Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('psychometric_test_code_id',$this->psychometric_test_code_id,true);
		$criteria->compare('school_ref_id',$this->school_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('gateway_payment_ref_id',$this->gateway_payment_ref_id,true);
		$criteria->compare('psych_code',$this->psych_code,true);
		$criteria->compare('discount_amount',$this->discount_amount,true);
		$criteria->compare('used_on',$this->used_on,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('test_type',$this->test_type,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}