<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSchoolFranchise is autogenerate by UniModel generator
 *
 * This is the model class for table "school_franchise".
 *
 * The followings are the available columns in table 'school_franchise':
 * @property string $school_franchise_id
 * @property integer $school_ref_id
 * @property integer $franchise_ref_id
 * @property string $franchise_status
 * @property string $is_free
 * @property string $fread_on
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $remarks
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property FranchiseInfo $franchiseRef
 * @property LookupSchool $schoolRef
 */
class BaseSchoolFranchise extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SchoolFranchise the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'school_franchise';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('school_ref_id, franchise_ref_id', 'numerical', 'integerOnly'=>true),
			array('franchise_status', 'length', 'max'=>25),
			array('is_free', 'length', 'max'=>1),
			array('added_by', 'length', 'max'=>10),
			array('fread_on, added_on, modified_on, remarks', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('school_franchise_id, school_ref_id, franchise_ref_id, franchise_status, is_free, fread_on, added_on, added_by, modified_on, remarks', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'franchiseRef' => array(self::BELONGS_TO, 'FranchiseInfo', 'franchise_ref_id'),
			'schoolRef' => array(self::BELONGS_TO, 'LookupSchool', 'school_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'school_franchise_id' => 'School Franchise',
			'school_ref_id' => 'School Ref',
			'franchise_ref_id' => 'Franchise Ref',
			'franchise_status' => 'Franchise Status',
			'is_free' => 'Is Free',
			'fread_on' => 'Fread On',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'remarks' => 'Remarks',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('school_franchise_id',$this->school_franchise_id,true);
		$criteria->compare('school_ref_id',$this->school_ref_id);
		$criteria->compare('franchise_ref_id',$this->franchise_ref_id);
		$criteria->compare('franchise_status',$this->franchise_status,true);
		$criteria->compare('is_free',$this->is_free,true);
		$criteria->compare('fread_on',$this->fread_on,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('remarks',$this->remarks,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}