<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSeoState is autogenerate by UniModel generator
 *
 * This is the model class for table "seo_state".
 *
 * The followings are the available columns in table 'seo_state':
 * @property string $seo_state_id
 * @property integer $state_ref_id
 * @property string $seo_state_name
 *
 * The followings are the available model relations:
 * @property TblState $stateRef
 */
class BaseSeoState extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SeoState the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'seo_state';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('state_ref_id, seo_state_name', 'required'),
			array('state_ref_id', 'numerical', 'integerOnly'=>true),
			array('seo_state_name', 'length', 'max'=>75),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('seo_state_id, state_ref_id, seo_state_name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'stateRef' => array(self::BELONGS_TO, 'TblState', 'state_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'seo_state_id' => 'Seo State',
			'state_ref_id' => 'State Ref',
			'seo_state_name' => 'Seo State Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('seo_state_id',$this->seo_state_id,true);
		$criteria->compare('state_ref_id',$this->state_ref_id);
		$criteria->compare('seo_state_name',$this->seo_state_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}