<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSessionTimeslot is autogenerate by UniModel generator
 *
 * This is the model class for table "session_timeslot".
 *
 * The followings are the available columns in table 'session_timeslot':
 * @property string $timeslot_id
 * @property integer $advisor_ref_id
 * @property string $start_time
 * @property string $end_time
 * @property integer $reassigned_by
 * @property string $added_on
 * @property string $modified_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property SessionBookingTimeslot[] $sessionBookingTimeslots
 * @property TblAdmin $advisorRef
 * @property TblAdmin $reassignedBy
 */
class BaseSessionTimeslot extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SessionTimeslot the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'session_timeslot';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('advisor_ref_id, start_time, end_time, added_on', 'required'),
			array('advisor_ref_id, reassigned_by', 'numerical', 'integerOnly'=>true),
			array('added_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('timeslot_id, advisor_ref_id, start_time, end_time, reassigned_by, added_on, modified_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'sessionBookingTimeslots' => array(self::HAS_MANY, 'SessionBookingTimeslot', 'timeslot_ref_id'),
			'advisorRef' => array(self::BELONGS_TO, 'TblAdmin', 'advisor_ref_id'),
			'reassignedBy' => array(self::BELONGS_TO, 'TblAdmin', 'reassigned_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'timeslot_id' => 'Timeslot',
			'advisor_ref_id' => 'Advisor Ref',
			'start_time' => 'Start Time',
			'end_time' => 'End Time',
			'reassigned_by' => 'Reassigned By',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('timeslot_id',$this->timeslot_id,true);
		$criteria->compare('advisor_ref_id',$this->advisor_ref_id);
		$criteria->compare('start_time',$this->start_time,true);
		$criteria->compare('end_time',$this->end_time,true);
		$criteria->compare('reassigned_by',$this->reassigned_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}