<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSmsSubscription is autogenerate by UniModel generator
 *
 * This is the model class for table "sms_subscription".
 *
 * The followings are the available columns in table 'sms_subscription':
 * @property string $sms_subscription_id
 * @property string $user_ref_id
 * @property string $student_contact_ref_id
 * @property string $type_of_service
 * @property string $is_unsubscribed
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property StudentContactNumber $studentContactRef
 */
class BaseSmsSubscription extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SmsSubscription the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'sms_subscription';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('user_ref_id, student_contact_ref_id', 'length', 'max'=>10),
			array('type_of_service', 'length', 'max'=>7),
			array('is_unsubscribed', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('sms_subscription_id, user_ref_id, student_contact_ref_id, type_of_service, is_unsubscribed, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'studentContactRef' => array(self::BELONGS_TO, 'StudentContactNumber', 'student_contact_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'sms_subscription_id' => 'Sms Subscription',
			'user_ref_id' => 'User Ref',
			'student_contact_ref_id' => 'Student Contact Ref',
			'type_of_service' => 'Type Of Service',
			'is_unsubscribed' => 'Is Unsubscribed',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('sms_subscription_id',$this->sms_subscription_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('student_contact_ref_id',$this->student_contact_ref_id,true);
		$criteria->compare('type_of_service',$this->type_of_service,true);
		$criteria->compare('is_unsubscribed',$this->is_unsubscribed,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}