<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentEntranceExamVendorBranch is autogenerate by UniModel generator
 *
 * This is the model class for table "student_entrance_exam_vendor_branch".
 *
 * The followings are the available columns in table 'student_entrance_exam_vendor_branch':
 * @property string $student_entrance_vendor_id
 * @property string $user_ref_id
 * @property integer $entrance_exam_ref_id
 * @property string $vendor_branch_ref_id
 * @property integer $sub_dept_ref_id
 * @property string $vendor_name
 * @property integer $not_sure
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property EntranceExam $entranceExamRef
 * @property VendorBranch $vendorBranchRef
 */
class BaseStudentEntranceExamVendorBranch extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentEntranceExamVendorBranch the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_entrance_exam_vendor_branch';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, entrance_exam_ref_id, sub_dept_ref_id', 'required'),
			array('entrance_exam_ref_id, not_sure', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, vendor_branch_ref_id', 'length', 'max'=>10),
			array('vendor_name', 'length', 'max'=>100),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_entrance_vendor_id, user_ref_id, sub_dept_ref_id, entrance_exam_ref_id, vendor_branch_ref_id, vendor_name, not_sure, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'vendorBranchRef' => array(self::BELONGS_TO, 'VendorBranch', 'vendor_branch_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_entrance_vendor_id' => 'Student Entrance Vendor',
			'user_ref_id' => 'User Ref',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'vendor_branch_ref_id' => 'Vendor Branch Ref',
		    'sub_dept_ref_id' => 'Sub Dept Ref',
			'vendor_name' => 'Vendor Name',
			'not_sure' => 'Not Sure',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_entrance_vendor_id',$this->student_entrance_vendor_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('vendor_branch_ref_id',$this->vendor_branch_ref_id,true);
		$criteria->compare('vendor_name',$this->vendor_name,true);
		$criteria->compare('not_sure',$this->not_sure);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}