<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentSubjectHelp is autogenerate by UniModel generator
 *
 * This is the model class for table "student_subject_help".
 *
 * The followings are the available columns in table 'student_subject_help':
 * @property string $subject_help_id
 * @property string $student_ref_id
 * @property integer $subject_ref_id
 * @property integer $entered_by
 * @property string $entered_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $enteredBy
 * @property TblUserMaster $studentRef
 * @property LookupStudentSubject $subjectRef
 */
class BaseStudentSubjectHelp extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentSubjectHelp the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_subject_help';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_ref_id, subject_ref_id, entered_by, entered_on', 'required'),
			array('subject_ref_id, entered_by', 'numerical', 'integerOnly'=>true),
			array('student_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('subject_help_id, student_ref_id, subject_ref_id, entered_by, entered_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'enteredBy' => array(self::BELONGS_TO, 'TblAdmin', 'entered_by'),
			'studentRef' => array(self::BELONGS_TO, 'TblUserMaster', 'student_ref_id'),
			'subjectRef' => array(self::BELONGS_TO, 'LookupStudentSubject', 'subject_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'subject_help_id' => 'Subject Help',
			'student_ref_id' => 'Student Ref',
			'subject_ref_id' => 'Subject Ref',
			'entered_by' => 'Entered By',
			'entered_on' => 'Entered On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('subject_help_id',$this->subject_help_id,true);
		$criteria->compare('student_ref_id',$this->student_ref_id,true);
		$criteria->compare('subject_ref_id',$this->subject_ref_id);
		$criteria->compare('entered_by',$this->entered_by);
		$criteria->compare('entered_on',$this->entered_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}