<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblActivityScore is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_activity_score".
 *
 * The followings are the available columns in table 'tbl_activity_score':
 * @property string $tbl_activity_score_id
 * @property string $field_name
 * @property string $activity_category
 * @property string $activity_weightage
 * @property string $group_weighatage
 * @property string $reference_table
 * @property string $reference_field
 * @property string $check_condition
 * @property string $is_active
 * @property string $date_field
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property ActivityLevelValues[] $activityLevelValues
 */
class BaseTblActivityScore extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblActivityScore the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_activity_score';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('field_name, reference_table', 'length', 'max'=>100),
			array('activity_category', 'length', 'max'=>10),
			array('activity_weightage, group_weighatage', 'length', 'max'=>4),
			array('reference_field, date_field', 'length', 'max'=>50),
			array('check_condition', 'length', 'max'=>255),
			array('is_active', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tbl_activity_score_id, field_name, activity_category, activity_weightage, group_weighatage, reference_table, reference_field, check_condition, is_active, date_field, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'activityLevelValues' => array(self::HAS_MANY, 'ActivityLevelValues', 'activity_score_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tbl_activity_score_id' => 'Tbl Activity Score',
			'field_name' => 'Field Name',
			'activity_category' => 'Activity Category',
			'activity_weightage' => 'Activity Weightage',
			'group_weighatage' => 'Group Weighatage',
			'reference_table' => 'Reference Table',
			'reference_field' => 'Reference Field',
			'check_condition' => 'Check Condition',
			'is_active' => 'Is Active',
			'date_field' => 'Date Field',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tbl_activity_score_id',$this->tbl_activity_score_id,true);
		$criteria->compare('field_name',$this->field_name,true);
		$criteria->compare('activity_category',$this->activity_category,true);
		$criteria->compare('activity_weightage',$this->activity_weightage,true);
		$criteria->compare('group_weighatage',$this->group_weighatage,true);
		$criteria->compare('reference_table',$this->reference_table,true);
		$criteria->compare('reference_field',$this->reference_field,true);
		$criteria->compare('check_condition',$this->check_condition,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('date_field',$this->date_field,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}