<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblSiDi is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_si_di".
 *
 * The followings are the available columns in table 'tbl_si_di':
 * @property integer $inst_id
 * @property string $login_ref_id
 * @property string $inst_type
 * @property string $inst_code
 * @property string $inst_username
 * @property string $inst_password
 * @property string $inst_name
 * @property string $principal_email
 * @property string $si_head_name
 * @property string $si_head_title
 * @property integer $school_ref_id
 * @property string $amount
 * @property string $inst_slug_name
 * @property integer $css_access
 * @property string $subdomain_slug_name
 * @property string $inst_email
 * @property string $business_model
 * @property string $client_prospect
 * @property integer $student_limit
 * @property string $url_keyword
 * @property string $inst_logo
 * @property string $signup_bg_image
 * @property string $name_of_trust
 * @property string $affiliation_body
 * @property string $main_country_operation
 * @property string $countries_operating
 * @property string $inst_address
 * @property integer $city_ref_id
 * @property integer $inst_country
 * @property string $inst_zipcode
 * @property string $longitute
 * @property string $latitute
 * @property string $inst_contact_no
 * @property string $inst_call_time
 * @property string $inst_website
 * @property string $founding_year
 * @property string $intl_stud_allow
 * @property string $profile
 * @property string $vision_statement
 * @property string $education_levels_offered
 * @property string $main_education_offered
 * @property string $flagship_subjects_courses
 * @property string $inst_ranking
 * @property string $courses_offered
 * @property string $famous_alumni
 * @property string $graduation_month
 * @property string $graduation_year
 * @property integer $total_campus
 * @property integer $total_students
 * @property integer $total_students_graduating
 * @property double $graduating_class_going_abroad_per
 * @property integer $full_time
 * @property integer $part_time
 * @property double $male_stud_per
 * @property double $female_stud_per
 * @property string $approx_fees
 * @property string $student_professor_ratio
 * @property string $students_ratings_reviews
 * @property string $partnership_ref_ids
 * @property string $other_partnerships
 * @property string $global_partnership_tie_ups
 * @property string $auto_escalate_flag
 * @property integer $auto_escalate_interval
 * @property string $is_confirm
 * @property string $is_active
 * @property string $added_on
 * @property string $modified_on
 * @property string $changeed_password
 * @property string $school_type
 * @property string $is_test
 * @property string $inst_city
 * @property string $is_popular
 *
 * The followings are the available model relations:
 * @property CriteriaPreferredSchool[] $criteriaPreferredSchools
 * @property EventSi[] $eventSis
 * @property SiAdvisor[] $siAdvisors
 * @property SiMilestoneDate[] $siMilestoneDates
 * @property SiMilestoneNotes[] $siMilestoneNotes
 * @property SiMilestoneReminder[] $siMilestoneReminders
 * @property SiTrackMilestone[] $siTrackMilestones
 * @property StudentUpgradeLog[] $studentUpgradeLogs
 * @property StudentUpgradeLog[] $studentUpgradeLogs1
 * @property StudentUploadMasterList[] $studentUploadMasterLists
 * @property StudentUploadMasterNoEmail[] $studentUploadMasterNoEmails
 * @property TaskSchool[] $taskSchools
 * @property TblAdmin[] $tblAdmins
 * @property TblSiBoard[] $tblSiBoards
 * @property TblCityMaster $cityRef
 * @property LoginMaster $loginRef
 * @property LookupSchool $schoolRef
 * @property TblSiStudents[] $tblSiStudents
 * @property WorkshopSi[] $workshopSis
 */
class BaseTblSiDi extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblSiDi the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_si_di';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('amount', 'required'),
			array('school_ref_id, css_access, student_limit, city_ref_id, inst_country, total_campus, total_students, total_students_graduating, full_time, part_time, auto_escalate_interval', 'numerical', 'integerOnly'=>true),
			array('graduating_class_going_abroad_per, male_stud_per, female_stud_per', 'numerical'),
			array('login_ref_id, amount, business_model, founding_year', 'length', 'max'=>10),
			array('inst_type, inst_code', 'length', 'max'=>2),
			array('inst_username, inst_password, longitute, latitute, graduation_month, graduation_year, approx_fees, student_professor_ratio', 'length', 'max'=>50),
			array('inst_name, principal_email, inst_slug_name, subdomain_slug_name, inst_email, inst_logo, signup_bg_image, name_of_trust, main_country_operation, inst_contact_no, inst_call_time, partnership_ref_ids, other_partnerships, global_partnership_tie_ups', 'length', 'max'=>255),
            array('si_head_name', 'length', 'max'=>200),
            array('si_head_title', 'length', 'max'=>150),
            array('client_prospect', 'length', 'max'=>8),
			array('url_keyword', 'length', 'max'=>45),
			array('inst_zipcode', 'length', 'max'=>20),
			array('intl_stud_allow', 'length', 'max'=>3),
			array('inst_ranking', 'length', 'max'=>100),
			array('auto_escalate_flag, is_confirm, is_active, changeed_password, school_type, is_test, is_popular', 'length', 'max'=>1),
			array('affiliation_body, countries_operating, inst_address, inst_website, profile, vision_statement, education_levels_offered, main_education_offered, flagship_subjects_courses, courses_offered, famous_alumni, students_ratings_reviews, added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('inst_id, login_ref_id, inst_type, inst_code, inst_username, inst_password, inst_name, principal_email, si_head_name, si_head_title, school_ref_id, amount, inst_slug_name, css_access, subdomain_slug_name, inst_email, business_model, client_prospect, student_limit, url_keyword, inst_logo, signup_bg_image, name_of_trust, affiliation_body, main_country_operation, countries_operating, inst_address, city_ref_id, inst_country, inst_zipcode, longitute, latitute, inst_contact_no, inst_call_time, inst_website, founding_year, intl_stud_allow, profile, vision_statement, education_levels_offered, main_education_offered, flagship_subjects_courses, inst_ranking, courses_offered, famous_alumni, graduation_month, graduation_year, total_campus, total_students, total_students_graduating, graduating_class_going_abroad_per, full_time, part_time, male_stud_per, female_stud_per, approx_fees, student_professor_ratio, students_ratings_reviews, partnership_ref_ids, other_partnerships, global_partnership_tie_ups, auto_escalate_flag, auto_escalate_interval, is_confirm, is_active, added_on, modified_on, changeed_password, school_type, is_test, school_code', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'criteriaPreferredSchools' => array(self::HAS_MANY, 'CriteriaPreferredSchool', 'si_ref_id'),
			'eventSis' => array(self::HAS_MANY, 'EventSi', 'si_ref_id'),
			'siAdvisors' => array(self::HAS_MANY, 'SiAdvisor', 'si_id'),
			'siMilestoneDates' => array(self::HAS_MANY, 'SiMilestoneDate', 'si_ref_id'),
			'siMilestoneNotes' => array(self::HAS_MANY, 'SiMilestoneNotes', 'si_ref_id'),
			'siMilestoneReminders' => array(self::HAS_MANY, 'SiMilestoneReminder', 'si_ref_id'),
			'siTrackMilestones' => array(self::HAS_MANY, 'SiTrackMilestone', 'si_ref_id'),
			'studentUpgradeLogs' => array(self::HAS_MANY, 'StudentUpgradeLog', 'new_si_ref_id'),
			'studentUpgradeLogs1' => array(self::HAS_MANY, 'StudentUpgradeLog', 'old_si_ref_id'),
			'studentUploadMasterLists' => array(self::HAS_MANY, 'StudentUploadMasterList', 'inst_ref_id'),
			'studentUploadMasterNoEmails' => array(self::HAS_MANY, 'StudentUploadMasterNoEmail', 'inst_ref_id'),
			'taskSchools' => array(self::HAS_MANY, 'TaskSchool', 'si_ref_id'),
			'tblAdmins' => array(self::HAS_MANY, 'TblAdmin', 'si_ref_id'),
			'tblSiBoards' => array(self::HAS_MANY, 'TblSiBoard', 'si_ref_id'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
			'schoolRef' => array(self::BELONGS_TO, 'LookupSchool', 'school_ref_id'),
			'tblSiStudents' => array(self::HAS_MANY, 'TblSiStudents', 'inst_ref_id'),
			'workshopSis' => array(self::HAS_MANY, 'WorkshopSi', 'si_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'inst_id' => 'Inst',
			'login_ref_id' => 'Login Ref',
			'inst_type' => 'Inst Type',
			'inst_code' => 'Inst Code',
			'inst_username' => 'Inst Username',
			'inst_password' => 'Inst Password',
			'inst_name' => 'Inst Name',
            'principal_email' => 'Principal Email',
            'si_head_name' => 'Si Head Name',
            'si_head_title' => 'Si Head Title',
			'school_ref_id' => 'School Ref',
			'amount' => 'Amount',
			'inst_slug_name' => 'Inst Slug Name',
			'css_access' => 'Css Access',
			'subdomain_slug_name' => 'Subdomain Slug Name',
			'inst_email' => 'Inst Email',
			'business_model' => 'Business Model',
			'client_prospect' => 'Client Prospect',
			'student_limit' => 'Student Limit',
			'url_keyword' => 'Url Keyword',
			'inst_logo' => 'Inst Logo',
			'signup_bg_image' => 'Signup Bg Image',
			'name_of_trust' => 'Name Of Trust',
			'affiliation_body' => 'Affiliation Body',
			'main_country_operation' => 'Main Country Operation',
			'countries_operating' => 'Countries Operating',
			'inst_address' => 'Inst Address',
			'city_ref_id' => 'City Ref',
			'inst_country' => 'Inst Country',
			'inst_zipcode' => 'Inst Zipcode',
			'longitute' => 'Longitute',
			'latitute' => 'Latitute',
			'inst_contact_no' => 'Inst Contact No',
			'inst_call_time' => 'Inst Call Time',
			'inst_website' => 'Inst Website',
			'founding_year' => 'Founding Year',
			'intl_stud_allow' => 'Intl Stud Allow',
			'profile' => 'Profile',
			'vision_statement' => 'Vision Statement',
			'education_levels_offered' => 'Education Levels Offered',
			'main_education_offered' => 'Main Education Offered',
			'flagship_subjects_courses' => 'Flagship Subjects Courses',
			'inst_ranking' => 'Inst Ranking',
			'courses_offered' => 'Courses Offered',
			'famous_alumni' => 'Famous Alumni',
			'graduation_month' => 'Graduation Month',
			'graduation_year' => 'Graduation Year',
			'total_campus' => 'Total Campus',
			'total_students' => 'Total Students',
			'total_students_graduating' => 'Total Students Graduating',
			'graduating_class_going_abroad_per' => 'Graduating Class Going Abroad Per',
			'full_time' => 'Full Time',
			'part_time' => 'Part Time',
			'male_stud_per' => 'Male Stud Per',
			'female_stud_per' => 'Female Stud Per',
			'approx_fees' => 'Approx Fees',
			'student_professor_ratio' => 'Student Professor Ratio',
			'students_ratings_reviews' => 'Students Ratings Reviews',
			'partnership_ref_ids' => 'Partnership Ref Ids',
			'other_partnerships' => 'Other Partnerships',
			'global_partnership_tie_ups' => 'Global Partnership Tie Ups',
			'auto_escalate_flag' => 'Auto Escalate Flag',
			'auto_escalate_interval' => 'Auto Escalate Interval',
			'is_confirm' => 'Is Confirm',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
			'changeed_password' => 'Changeed Password',
			'school_type' => 'School Type',
			'is_test' => 'Is Test',
            'inst_city' => 'Inst City',
            'is_popular' => 'Is Popular',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('inst_id',$this->inst_id);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('inst_type',$this->inst_type,true);
		$criteria->compare('inst_code',$this->inst_code,true);
		$criteria->compare('inst_username',$this->inst_username,true);
        $criteria->compare('principal_email',$this->principal_email,true);
		$criteria->compare('inst_password',$this->inst_password,true);
		$criteria->compare('inst_name',$this->inst_name,true);
        $criteria->compare('si_head_name',$this->si_head_name,true);
        $criteria->compare('si_head_title',$this->si_head_title,true);
		$criteria->compare('school_ref_id',$this->school_ref_id);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('inst_slug_name',$this->inst_slug_name,true);
		$criteria->compare('css_access',$this->css_access);
		$criteria->compare('subdomain_slug_name',$this->subdomain_slug_name,true);
		$criteria->compare('inst_email',$this->inst_email,true);
		$criteria->compare('business_model',$this->business_model,true);
		$criteria->compare('client_prospect',$this->client_prospect,true);
		$criteria->compare('student_limit',$this->student_limit);
		$criteria->compare('url_keyword',$this->url_keyword,true);
		$criteria->compare('inst_logo',$this->inst_logo,true);
		$criteria->compare('signup_bg_image',$this->signup_bg_image,true);
		$criteria->compare('name_of_trust',$this->name_of_trust,true);
		$criteria->compare('affiliation_body',$this->affiliation_body,true);
		$criteria->compare('main_country_operation',$this->main_country_operation,true);
		$criteria->compare('countries_operating',$this->countries_operating,true);
		$criteria->compare('inst_address',$this->inst_address,true);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('inst_country',$this->inst_country);
		$criteria->compare('inst_zipcode',$this->inst_zipcode,true);
		$criteria->compare('longitute',$this->longitute,true);
		$criteria->compare('latitute',$this->latitute,true);
		$criteria->compare('inst_contact_no',$this->inst_contact_no,true);
		$criteria->compare('inst_call_time',$this->inst_call_time,true);
		$criteria->compare('inst_website',$this->inst_website,true);
		$criteria->compare('founding_year',$this->founding_year,true);
		$criteria->compare('intl_stud_allow',$this->intl_stud_allow,true);
		$criteria->compare('profile',$this->profile,true);
		$criteria->compare('vision_statement',$this->vision_statement,true);
		$criteria->compare('education_levels_offered',$this->education_levels_offered,true);
		$criteria->compare('main_education_offered',$this->main_education_offered,true);
		$criteria->compare('flagship_subjects_courses',$this->flagship_subjects_courses,true);
		$criteria->compare('inst_ranking',$this->inst_ranking,true);
		$criteria->compare('courses_offered',$this->courses_offered,true);
		$criteria->compare('famous_alumni',$this->famous_alumni,true);
		$criteria->compare('graduation_month',$this->graduation_month,true);
		$criteria->compare('graduation_year',$this->graduation_year,true);
		$criteria->compare('total_campus',$this->total_campus);
		$criteria->compare('total_students',$this->total_students);
		$criteria->compare('total_students_graduating',$this->total_students_graduating);
		$criteria->compare('graduating_class_going_abroad_per',$this->graduating_class_going_abroad_per);
		$criteria->compare('full_time',$this->full_time);
		$criteria->compare('part_time',$this->part_time);
		$criteria->compare('male_stud_per',$this->male_stud_per);
		$criteria->compare('female_stud_per',$this->female_stud_per);
		$criteria->compare('approx_fees',$this->approx_fees,true);
		$criteria->compare('student_professor_ratio',$this->student_professor_ratio,true);
		$criteria->compare('students_ratings_reviews',$this->students_ratings_reviews,true);
		$criteria->compare('partnership_ref_ids',$this->partnership_ref_ids,true);
		$criteria->compare('other_partnerships',$this->other_partnerships,true);
		$criteria->compare('global_partnership_tie_ups',$this->global_partnership_tie_ups,true);
		$criteria->compare('auto_escalate_flag',$this->auto_escalate_flag,true);
		$criteria->compare('auto_escalate_interval',$this->auto_escalate_interval);
		$criteria->compare('is_confirm',$this->is_confirm,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('changeed_password',$this->changeed_password,true);
		$criteria->compare('school_type',$this->school_type,true);
		$criteria->compare('is_test',$this->is_test,true);
        $criteria->compare('inst_city',$this->inst_city,true);
        $criteria->compare('is_popular',$this->is_popular,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}