<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniCourseReservation is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_course_reservation".
 *
 * The followings are the available columns in table 'uni_course_reservation':
 * @property string $uni_course_reservation_id
 * @property integer $uni_ref_id
 * @property string $uni_course_ref_id
 * @property integer $reservation_ref_id
 * @property double $reservation_percent
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property TblAdmin $modifiedBy
 * @property LookupReservation $reservationRef
 */
class BaseUniCourseReservation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniCourseReservation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_course_reservation';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('reservation_ref_id', 'required'),
			array('uni_ref_id, reservation_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('reservation_percent', 'numerical'),
			array('uni_course_ref_id', 'length', 'max'=>11),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('uni_course_reservation_id, uni_ref_id, uni_course_ref_id, reservation_ref_id, reservation_percent, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'reservationRef' => array(self::BELONGS_TO, 'LookupReservation', 'reservation_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'uni_course_reservation_id' => 'Uni Course Reservation',
			'uni_ref_id' => 'Uni Ref',
			'uni_course_ref_id' => 'Uni Course Ref',
			'reservation_ref_id' => 'Reservation Ref',
			'reservation_percent' => 'Reservation Percent',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('uni_course_reservation_id',$this->uni_course_reservation_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('uni_course_ref_id',$this->uni_course_ref_id,true);
		$criteria->compare('reservation_ref_id',$this->reservation_ref_id);
		$criteria->compare('reservation_percent',$this->reservation_percent);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}