<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserUniApplication is autogenerate by UniModel generator
 *
 * This is the model class for table "user_uni_application".
 *
 * The followings are the available columns in table 'user_uni_application':
 * @property integer $user_uni_application_id
 * @property string $user_ref_id
 * @property integer $uni_ref_id
 * @property string $course_ref_id
 * @property string $course_name
 * @property string $application_id
 * @property string $comment
 * @property string $tentative_date
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $uniRef
 * @property TblUserMaster $userRef
 * @property TblUniCourses $courseRef
 */
class BaseUserUniApplication extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserUniApplication the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_uni_application';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			// array('added_on', 'required'),
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, course_ref_id', 'length', 'max'=>10),
			array('course_name', 'length', 'max'=>250),
			array('application_id', 'length', 'max'=>20),
			array('comment, tentative_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_uni_application_id, user_ref_id, uni_ref_id, course_ref_id, course_name, application_id, comment, tentative_date, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'courseRef' => array(self::BELONGS_TO, 'TblUniCourses', 'course_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_uni_application_id' => 'User Uni Application',
			'user_ref_id' => 'User Ref',
			'uni_ref_id' => 'Uni Ref',
			'course_ref_id' => 'Course Ref',
			'course_name' => 'Course Name',
			'application_id' => 'Application',
			'comment' => 'Comment',
			'tentative_date' => 'Tentative Date',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_uni_application_id',$this->user_uni_application_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('course_ref_id',$this->course_ref_id,true);
		$criteria->compare('course_name',$this->course_name,true);
		$criteria->compare('application_id',$this->application_id,true);
		$criteria->compare('comment',$this->comment,true);
		$criteria->compare('tentative_date',$this->tentative_date,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}