<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentreStudentStatus is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre_student_status".
 *
 * The followings are the available columns in table 'vendor_centre_student_status':
 * @property string $vendor_centre_student_status_id
 * @property string $interaction_type
 * @property string $interaction_date
 * @property string $next_interaction_date
 * @property string $student_status_ref_id
 * @property string $interaction_summary
 * @property string $foreign_key
 * @property string $foreign_model
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupCentreStudentStatus $studentStatusRef
 * @property LoginMaster $addedBy
 */
class BaseVendorCentreStudentStatus extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentreStudentStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre_student_status';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('interaction_date, foreign_key, foreign_model, added_by', 'required'),
			array('interaction_type', 'length', 'max'=>12),
			array('student_status_ref_id, foreign_key, added_by', 'length', 'max'=>10),
			array('foreign_model', 'length', 'max'=>100),
			array('next_interaction_date, interaction_summary, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_centre_student_status_id, interaction_type, interaction_date, next_interaction_date, student_status_ref_id, interaction_summary, foreign_key, foreign_model, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'studentStatusRef' => array(self::BELONGS_TO, 'LookupCentreStudentStatus', 'student_status_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_student_status_id' => 'Vendor Centre Student Status',
			'interaction_type' => 'Interaction Type',
			'interaction_date' => 'Interaction Date',
			'next_interaction_date' => 'Next Interaction Date',
			'student_status_ref_id' => 'Student Status Ref',
			'interaction_summary' => 'Interaction Summary',
			'foreign_key' => 'Foreign Key',
			'foreign_model' => 'Foreign Model',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_centre_student_status_id',$this->vendor_centre_student_status_id,true);
		$criteria->compare('interaction_type',$this->interaction_type,true);
		$criteria->compare('interaction_date',$this->interaction_date,true);
		$criteria->compare('next_interaction_date',$this->next_interaction_date,true);
		$criteria->compare('student_status_ref_id',$this->student_status_ref_id,true);
		$criteria->compare('interaction_summary',$this->interaction_summary,true);
		$criteria->compare('foreign_key',$this->foreign_key,true);
		$criteria->compare('foreign_model',$this->foreign_model,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}