<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorContact is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_contact".
 *
 * The followings are the available columns in table 'vendor_contact':
 * @property integer $vendor_contact_id
 * @property integer $vendor_ref_id
 * @property string $salutation
 * @property string $first_name
 * @property string $last_name
 * @property integer $user_type_ref_id
 * @property string $login_ref_id
 *
 * The followings are the available model relations:
 * @property Vendor $vendorRef
 * @property LookupUserType $userTypeRef
 * @property LoginMaster $loginRef
 * @property VendorContactNumber[] $vendorContactNumbers
 */
class BaseVendorContact extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorContact the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_contact';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_ref_id, user_type_ref_id', 'numerical', 'integerOnly'=>true),
			array('salutation', 'length', 'max'=>5),
			array('first_name, last_name', 'length', 'max'=>100),
			array('login_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_contact_id, vendor_ref_id, salutation, first_name, last_name, user_type_ref_id, login_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'vendorRef' => array(self::BELONGS_TO, 'Vendor', 'vendor_ref_id'),
                    'userTypeRef' => array(self::BELONGS_TO, 'LookupUserType', 'user_type_ref_id'),
                    'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
                    'vendorContactNumbers' => array(self::HAS_MANY, 'VendorContactNumber', 'vendor_contact_ref_id'),
                    'vendorExpertAwards' => array(self::HAS_MANY, 'VendorExpertAwards', 'vendor_contact_ref_id'),
                    'vendorExpertCertifications' => array(self::HAS_MANY, 'VendorExpertCertification', 'vendor_contact_ref_id'),
                    'vendorExpertCommunication' => array(self::HAS_ONE, 'VendorExpertCommunication', 'vendor_contact_ref_id'),
                    'vendorExpertInfo' => array(self::HAS_ONE, 'VendorExpertInfo', 'vendor_contact_ref_id'),
                    'vendorExpertQualifications' => array(self::HAS_MANY, 'VendorExpertQualification', 'vendor_contact_ref_id'),
                    'vendorExpertiseCountries' => array(self::HAS_MANY, 'VendorExpertiseCountry', 'vendor_contact_ref_id'),
                    'vendorExpertiseDepartments' => array(self::HAS_MANY, 'VendorExpertiseDepartment', 'vendor_contact_ref_id'),
                    'vendorExpertiseTests' => array(self::HAS_MANY, 'VendorExpertiseTest', 'vendor_contact_ref_id'),
                    'vendorExpertiseUniversities' => array(self::HAS_MANY, 'VendorExpertiseUniversity', 'vendor_contact_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_contact_id' => 'Vendor Contact',
			'vendor_ref_id' => 'Vendor Ref',
			'salutation' => 'Salutation',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'user_type_ref_id' => 'User Type Ref',
			'login_ref_id' => 'Login Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_contact_id',$this->vendor_contact_id);
		$criteria->compare('vendor_ref_id',$this->vendor_ref_id);
		$criteria->compare('salutation',$this->salutation,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('user_type_ref_id',$this->user_type_ref_id);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}