<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseWebinarEventDepartments is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_events_departments".
 *
 * The followings are the available columns in table 'tbl_events_departments':
 * @property integer $tbl_events_departments_id
 * @property integer $event_ref_id
 * @property integer $department_ref_id
 * @property string $is_active
 *
 * The followings are the available model relations:
 * @property TblEvent $eventRef
 * @property LookupDepartment $departmentRef
 */
class BaseWebinarEventDepartments extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WebinarEventDepartments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_events_departments';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_ref_id, department_ref_id', 'numerical', 'integerOnly'=>true),
			array('is_active', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tbl_events_departments_id, event_ref_id, department_ref_id, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventRef' => array(self::BELONGS_TO, 'TblEvent', 'event_ref_id'),
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tbl_events_departments_id' => 'Tbl Events Departments',
			'event_ref_id' => 'Event Ref',
			'department_ref_id' => 'Department Ref',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tbl_events_departments_id',$this->tbl_events_departments_id);
		$criteria->compare('event_ref_id',$this->event_ref_id);
		$criteria->compare('department_ref_id',$this->department_ref_id);
		$criteria->compare('is_active',$this->is_active,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}