<section id="section1" class="section">
    <style>
        .error {
            border: medium none !important;
        }
        .error input, .error select {
            border: 1px solid #FC8383 !important;
        }
    </style>
    <div class="div-inner-gutter-space">
        <div class="row border-bottom gutter_vertical relative">
            <div class="titles">
                <h2 class="center uppercase gutter_vertical">Ideal List of Colleges</h2>
                <h4 class="center normal gutter_vertical">An ideal list is a very personalized list of colleges that we believe would be good as a prospective place to study and build your career based on your academics, choices of country and major</h4>
            </div>
        </div>

        <div class="row">
            <div class="row multi_line gutter-left-35 gutter_vertical">
                <h4 class="center normal gutter_vertical">To create your ideal list, please enter your board and overall marks in 12th that you expect to get, in the fields given blow -</h4>
                <form method="post" action="" onsubmit='return validateEducations()' >
                    <input type="hidden" name="marks" value="marks">
                <div class="row visible clearfix gutter_vertical">
                    <div class="grid_3 left">Choose Board</div>
                    <div class="left grid_4 relative">
                        <?php
                            $boardsList = CHtml::listData(LookupBoardEquivalent::GetSchoolBoardList(12), 'board_equivalent_id', 'board_desc');
                        ?>
                        <select class="grid_4" name="board" id="board" onchange="getOverAllMarks(this.value);">
                            <?php
                                echo "<option value=''>Choose your board</option>";
                                foreach ($boardsList as $key=>$val) {
                                    echo "<option value='$key'>$val</option>";
                                }
                            ?>
                        </select>
                        <div class="errorMessage popup" style="display:none" id="board_err"></div>
                    </div>
                </div>
                <div class="row visible clearfix " id="marks_sec">

                </div>
                <div class="row div-inner-gutter-space center">
                    <input type="submit" value="Create My Idealist" class="button-green tny gutter_horizontal"  />
                </div>
            </form>
            </div>
        </div>
        <script>
            function getOverAllMarks(boardId) {

                if(boardId){
                    $.ajax({
                        type : 'GET',
                        data : 'boardId='+boardId,
                        url  : '/app/createProfile/preferences/GetOverallAndSubjects',
                        async: false,
                        success : function (data){
                            $('#marks_sec').html(data);
                        }
                    });
                } else {
                    $('#marks_sec').html('');
                }
            }

            var regExNumeric = /^[0-9]+$/;
            var regexOnlyAlpha = /^[a-zA-Z ]+$/;
            var regexOnlyAlphaNumericButNotStartWithNumber = /^[a-zA-Z][a-zA-Z0-9 ]+$/;
            function validateEducations() {
                hasError = false;
                if($('#board').val() == ''){
                    $('#board').addClass('error_border');
                    $('#board_err').html('<div class="holder"><p>Select your board/curriculum of study</p></div>').show();
                    hasError = true;
                }else{
                    $('#board').removeClass('error_border');
                    $('#board_err').hide();
                }

                c12_lower = $('#overall_type').val();
                switch (c12_lower) {
                    case 'grades':
                        if (($('#overall_aa').val() == '0') && ($('#overall_a').val() == '0') && ($('#overall_b').val() == '0') && ($('#overall_c').val() == '0') && ($('#overall_d').val() == '0')) {
                            $('#overall_aa').addClass('error_border');
                            $('#overall_a').addClass('error_border');
                            $('#overall_b').addClass('error_border');
                            $('#overall_c').addClass('error_border');
                            $('#overall_d').addClass('error_border');
                            $('#overall_aa_err').html('<div class=holder><p>Select overall grades</p></div>').show();
                            hasError = true;
                        } else {
                            $('#overall_aa').removeClass('error_border');
                            $('#overall_a').removeClass('error_border');
                            $('#overall_b').removeClass('error_border');
                            $('#overall_c').removeClass('error_border');
                            $('#overall_d').removeClass('error_border');
                            $('#overall_aa_err').html('').hide();
                        }
                        break;
                    case 'marks-gpa':
                        var marksVal = $('#overall_marks').val();
                        var maxMarks = 100;
                        var match = $.isNumeric($('#overall_marks').val());

                        if(!match || $.trim(marksVal) == ''){
                            $('#overall_marks').addClass('error_border');
                            $('#overall_marks_err').html('<div class=holder><p>Enter overall marks</p></div>').show();
                            hasError = true;
                        } else if( $.trim(marksVal) != '' && !$.isNumeric(marksVal) ) {
                            $('#overall_marks').addClass('error_border');
                            $('#overall_marks_err').html('<div class=holder><p>Your overall marks should be number</p></div>').show();
                            hasError = true;
                        } else {
                            if(marksVal > maxMarks || marksVal < 0.6){ // Marks should be- < 100 and > 0.6
                                $('#overall_marks').addClass('error_border');
                                $('#overall_marks_err').html('<div class=holder><p>Marks should be in between 0.6 to 100</p></div>').show();
                                hasError = true;
                            }else{
                                $('#overall_marks').removeClass('error_border');
                                $('#overall_marks_err').hide();
                            }
                        }
                        break;
                    case 'points':
                        var points = $('#overall_points').val();
                        if(points == ''){
                            $('#overall_points').addClass('error_border');
                            $('#overall_points_err').html('<div class=holder><p>Select overall points</p></div>').show();
                            hasError = true;
                        }else{
                            $('#overall_points').removeClass('error_border');
                            $('#overall_points_err').hide();
                        }

                        break;

                    case 'marks':{
                        var marksVal = parseInt($('#overall_marks').val());
                        var maxMarks = 100;
                        var match = $.isNumeric($('#overall_marks').val());

                        if(!match || $.trim(marksVal) == ''){
                            $('#overall_marks').addClass('error_border');
                            $('#overall_marks_err').html('<div class=holder><p>Enter overall marks</p></div>').show();
                            hasError = true;
                        } else if( $.trim(marksVal) != '' && !$.isNumeric(marksVal) ) {
                            $('#overall_marks').addClass('error_border');
                            $('#overall_marks_err').html('<div class=holder><p>Your overall marks should be number</p></div>').show();
                            hasError = true;
                        } else {
                            if(marksVal > maxMarks || marksVal < 1){ // Marks should be- < 100 and > 0
                                $('#overall_marks').addClass('error_border');
                                $('#overall_marks_err').html('<div class=holder><p>Marks should be in between 1 to 100</p></div>').show();
                                hasError = true;
                            }else{
                                $('#overall_marks').removeClass('error_border');
                                $('#overall_marks_err').hide();
                            }
                        }
                        break;
                    }
                }
                if (hasError) {
                    return false;
                } else {
                    return true;
                }
            }
        </script>
</section>