<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Nkumar
 * To change this template use File | Settings | File Templates.
 */
class GuestUniversity extends CFormModel
{
    public $country;
    public $uniname;
    public $city;

    public $contact_name;
    public $contact_designation;
    public $contact_email;
    public $contact_number;

    public function rules(){

        return array(
            array('uniname, country', 'required', 'message'=>'{attribute} is required.'),
            array('city, contact_name, contact_designation, contact_email, contact_number', 'safe'),
        );
    }

    public function beforeValidate() {

        $this->getValidatorList()->add(CValidator::createValidator('validateContactInfo',$this,'contactinfo', array()));
        $this->getValidatorList()->add(CValidator::createValidator('isUniversityExist',$this,'uniname', array()));
        return  parent::beforeValidate();
    }

    public function isUniversityExist($attribute, $params){

        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = "t.uni_id, di.uni_ref_id AS uni_code"; // property hack for di table uni_ref_id
        $cdbCriteria->join   = " LEFT JOIN di ON di.uni_ref_id = t.uni_id";
        $cdbCriteria->addCondition("t.uni_name = '".$this->attributes[$attribute]."'", "AND");
        $model = TblUniversityMaster::model()->find($cdbCriteria);
        if($model && $model->uni_code)
            $this->addError($attribute, $this->getAttributeLabel($attribute) .' DI account is already exists.');
    }

    public function getUniNamesWithNoDI(){

        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = "t.uni_name";
        $cdbCriteria->join   = " LEFT JOIN di ON di.uni_ref_id = t.uni_id";
        $cdbCriteria->addCondition("di.uni_ref_id IS NULL", "AND");
        $cdbCriteria->addCondition("t.uni_name IS NOT NULL", "AND");
        $model = TblUniversityMaster::model()->findAll($cdbCriteria);
        $uniNames = array();
        foreach($model as $uniObject){
            $uniNames[] = $uniObject->uni_name;
        }
        return $uniNames;
    }

    public function validateContactInfo($attribute, $params){


        $emailsQueue = array();
        foreach($_POST['GuestUniversity'] as $k => $v){

            if(!is_int($k)) continue;
            foreach($v as $key => $val){
                switch($key){
                    case 'contact_name':
                    case 'contact_designation':
                        if(empty($val))
                            $this->addError($k.'['.$key.']', $this->getAttributeLabel($key) .' is required.');
                        break;
                    case 'contact_email':
                        if(empty($val))
                            $this->addError($k.'['.$key.']', $this->getAttributeLabel($key) .' is required.');
                        elseif(!filter_var($val, FILTER_VALIDATE_EMAIL))
                            $this->addError($k.'['.$key.']', $this->getAttributeLabel($key) .' is not valid.');
                        elseif(in_array($val, $emailsQueue)){
                            $this->addError($k.'['.$key.']', $this->getAttributeLabel($key) .' must be unique.');
                        }elseif(($model = LoginMaster::model()->findByAttributes(array('username' => $val))) != null){
                            $this->addError($k.'['.$key.']', $this->getAttributeLabel($key) .' is already being used.');
                        }
                        $emailsQueue[] = $val;
                        break;
                    case 'contact_number':
                        if(empty($val))
                            $this->addError($k.'['.$key.']', $this->getAttributeLabel($key) .' is required.');
                        elseif( !preg_match("/^[1-9]+[0-9]{0,12}$/i", $val) )
                            $this->addError($k.'['.$key.']', $this->getAttributeLabel($key) .' is not valid.');
                        break;
                }
            }
        }
    }

    public function attributeLabels(){

        return array(
            'country' => 'Country',
            'uniname'=> 'University',
            'city'=> 'City',
            'contact_name' => 'Person Name',
            'contact_designation' => 'Designation',
            'contact_email' => 'Email Address',
            'contact_number' => 'Contact Number',
        );
    }
}
