<?php
class SendOffer extends CFormModel
{

	/**
	 * @return array validation rules for model attributes.
	 */
	 
	public $eoiDepartmentId	 = 0;
	
	public $admissionChances = '';
	public $scholarshipChances = '';

	public $scholarshipId = '';
	public $scholarshipName = '';
	public $scholarshipPrice = '';
	public $scholarshipDescription = '';
	public $publishScholarship = 0;
	
	public $message = '';
	public $attachment = '';
	public $attachmentId = 0;
	
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
        return
            array(
				array('admissionChances, scholarshipId, scholarshipName, scholarshipPrice, scholarshipDescription, scholarshipChances, message,attachmentId','safe'),
				array('admissionChances','required'),
				array('eoiDepartmentId','required','message'=>'Eoi Department cannot be blank.'),
				array('scholarshipId,scholarshipChances','required','on'=>'DROPDOWN_SCHOLARSHIP'),
                array('scholarshipName, scholarshipPrice, scholarshipDescription, scholarshipChances', 'required','on'=>'CUSTOME_SCHOLARSHIP'),
				
				//array('scholarshipPrice', 'numerical', 'integerOnly'=>true,'on'=>'CUSTOME_SCHOLARSHIP'),
				array('scholarshipPrice', 'numerical', 'min'=>0, 'tooSmall'=>'Only numeric values allowed for Scholarship Price', 'on'=>'CUSTOME_SCHOLARSHIP'),
				
			    array('attachment', 'file', 'types'=>'jpg, gif, png, txt, xlsx, pdf, doc, ppt','on'=>'ATTACHMENT_UPLOAD'),
                //array('admissionChances, scholarshipId, scholarshipName, scholarshipPrice, scholarshipDescription, scholarshipChances, message, attachmentId', 'customValidation'),
			   
        );
	}


	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
            return array(
			'admissionChances'=>'Admission Chances: ',
			'scholarshipChances'=>'Student chance of getting scholarship'
            );
	}

    public function customValidation(){
$this->addError('admissionChances', 'test message');
    }

}
