<?php 

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiProduct is autogenerate by UniModel generator
 *
 * This is the model class for table "di_product".
 *
 * The followings are the available columns in table 'di_product':
 * @property string $di_product_id
 * @property integer $di_ref_id
 * @property integer $product_ref_id
 * @property integer $currency_ref_id
 * @property string $price
 * @property string $start_date
 * @property string $end_date
 * @property integer $is_active
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property DiCashDebit[] $diCashDebits
 * @property Di $diRef
 * @property LookupProduct $productRef
 * @property LookupCurrency $currencyRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 */
class BaseDiProduct extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiProduct the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_product';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_ref_id, product_ref_id, currency_ref_id, price, is_active, added_on, added_by', 'required'),
			array('di_ref_id, product_ref_id, currency_ref_id, is_active', 'numerical', 'integerOnly'=>true),
			array('price, added_by, modified_by', 'length', 'max'=>10),
			array('start_date, end_date, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_product_id, di_ref_id, product_ref_id, currency_ref_id, price, start_date, end_date, is_active, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diCashDebits' => array(self::HAS_MANY, 'DiCashDebit', 'di_product_ref_id'),
			'diRef' => array(self::BELONGS_TO, 'Di', 'di_ref_id'),
			'productRef' => array(self::BELONGS_TO, 'LookupProduct', 'product_ref_id'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_product_id' => 'Di Product',
			'di_ref_id' => 'Di Ref',
			'product_ref_id' => 'Product Ref',
			'currency_ref_id' => 'Currency Ref',
			'price' => 'Price',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_product_id',$this->di_product_id,true);
		$criteria->compare('di_ref_id',$this->di_ref_id);
		$criteria->compare('product_ref_id',$this->product_ref_id);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('price',$this->price,true);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}