<?php 

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiUserDepartment is autogenerate by UniModel generator
 *
 * This is the model class for table "di_user_department".
 *
 * The followings are the available columns in table 'di_user_department':
 * @property integer $di_user_department_id
 * @property integer $di_user_ref_id
 * @property integer $main_department_ref_id
 * @property integer $is_active
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property DiUser $diUserRef
 * @property LookupDepartment $mainDepartmentRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 */
class BaseDiUserDepartment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiUserDepartment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_user_department';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_user_ref_id, main_department_ref_id, is_active, added_by, modified_by', 'required'),
			array('di_user_ref_id, main_department_ref_id, is_active', 'numerical', 'integerOnly'=>true),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_user_department_id, di_user_ref_id, main_department_ref_id, is_active, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diUserRef' => array(self::BELONGS_TO, 'DiUser', 'di_user_ref_id'),
			'mainDepartmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_department_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_user_department_id' => 'Di User Department',
			'di_user_ref_id' => 'Di User Ref',
			'main_department_ref_id' => 'Main Department Ref',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_user_department_id',$this->di_user_department_id);
		$criteria->compare('di_user_ref_id',$this->di_user_ref_id);
		$criteria->compare('main_department_ref_id',$this->main_department_ref_id);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}