<?php 
$this->breadcrumbs=array(
    'Di Accounts'=>array('/diadmin/di/admin'),
    'Manage Pricing'=>array('/diadmin/di/managepricing/','id'=>$di_id),
    'Manage Webinar Products'=>array('/diadmin/diProduct/listwebinars/di_id/'.$di_id),
    $editMode ? 'Edit Webinar Product' : 'Add Webinar Product',
);
$Di = Di::model()->with('currencyRef')->findByPk($di_id);
$currency = $Di->currencyRef->currency_code;
?>
<style>
    div.row{ margin-bottom: 5px !important;}
    div.row label, .LBLradio { width: 225px !important;}
    div.errorMessage { padding-left: 225px !important;}
    ul.token-input-list-facebook { clear: none; !important}
    div.hidden { display: none }
</style>
<h1><?php echo $editMode ? 'Edit Webinar Product' : 'Add Webinar Product'; ?></h1>
<div class="di_form">
    <div class="form">

        <?php $form=$this->beginWidget('CActiveForm', array(
        'id'=>'settings-form',
        'enableClientValidation'=>true,
        'enableAjaxValidation'=>true,
        'clientOptions'=>array(
			'validateOnSubmit' => true,
		)
        )); ?>

        <p class="note">Fields with <span class="required">*</span> are required.</p>

        <div class="row">&nbsp;</div>
        <div class="row">
            <?php echo $form->labelEx($model,'product_name'); ?>
            <?php echo $form->textField($model,'product_name'); ?>
            <?php echo $form->error($model,'product_name'); ?>
        </div>

        <div class="row">&nbsp;</div>
        <div class="row">
            <?php echo $form->labelEx($model,'amount_paid'); ?>
            <?php echo $form->textField($model,'amount_paid'); ?>
            <?php echo $currency; ?>
            <?php echo $form->error($model,'amount_paid'); ?>
        </div>

        <div class="row">&nbsp;</div>

        <div class="row">
            <?php echo $form->labelEx($model,'free_profile_count'); ?>
            <?php echo $form->textField($model,'free_profile_count'); ?>
            <?php echo $form->error($model,'free_profile_count'); ?>
        </div>

        <div class="row">&nbsp;</div>

        <div class="row">
            <?php echo $form->labelEx($model,'discounted_profile_price'); ?>
            <?php echo $form->textField($model,'discounted_profile_price'); ?>
            <?php echo $currency; ?>
            <?php echo $form->error($model,'discounted_profile_price'); ?>
        </div>

        <div class="row">&nbsp;</div>
        <div class="row">
            <?php
            echo CHtml::label($model->getAttributeLabel('duration_start_date'),'duration_start_date', array('required' => true));
            $this->widget('zii.widgets.jui.CJuiDatePicker', array(
            'attribute'=>'duration_start_date',
            'model'=>$model,
            'value'=>$model->duration_start_date,
            'options'=>array('dateFormat'=>'yy-mm-dd'),
            'htmlOptions'=>array('style'=>'height:20px;'),
            ));
            echo $form->error($model,'duration_start_date');
            ?>
        </div>

        <div class="row">&nbsp;</div>
        <div class="row">
            <?php
            echo CHtml::label($model->getAttributeLabel('duration_end_date'),'duration_end_date', array('required' => true));
            $this->widget('zii.widgets.jui.CJuiDatePicker', array(
            'attribute'=>'duration_end_date',
            'model'=>$model,
            'value'=>$model->duration_end_date,
            'options'=>array('dateFormat'=>'yy-mm-dd'),
            'htmlOptions'=>array('style'=>'height:20px;'),
            ));
            echo $form->error($model,'duration_end_date'); ?>
        </div>

        <div class="row">&nbsp;</div>
        <div class="row-radio">
            <?php echo $form->labelEx($model,'is_active',array('class'=>'LBLradio')); ?>
            <?php $model->is_active	=	(!isset($model->is_active)) ? 'Y' : $model->is_active;
            echo $form->radiobuttonList($model,'is_active',array('Y'=>'Yes','N'=>'No'),array('separator'=>' ')); ?>
            <?php echo $form->error($model,'is_active'); ?>
        </div>

        <div class="row">&nbsp;</div>
        <div class="row buttons">
            <label>&nbsp;</label>
            <input type="submit" class="button" value="Save" />
        </div>

        <?php $this->endWidget(); ?>

    </div><!-- form -->
</div>