<?php

class DefaultController extends BaseController {


    public function actionIndex(){

        $this->pageTitle = Yii::app()->name .' - Schools';
        
		$model = new ListModel;
        if(isset($_GET['ListModel'])){
            $model->attributes = $_GET['ListModel'];
        }
        $this->render('index', compact('model'));
    }

    public function actionStudents(){

        $this->pageTitle = Yii::app()->name .' - Students';
        $model = new ListModel;
        if(isset($_GET['ListModel'])){
            $model->attributes = $_GET['ListModel'];
        }
        $this->render('students', compact('model', 'schoolID'));
    }

    public function actionCreate(){

        $this->pageTitle = Yii::app()->name .' - Create Profile';
        $model = new ListModel('create_profile');

        if(Yii::app()->request->isAjaxRequest){
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if(Yii::app()->request->isPostRequest){
            $model->attributes = $_POST['ListModel'];
            if($model->validate() && ($studentID = $model->createProfile())){
                setFlashMessage('success_notify', 'globalnotifications.notification_geniric', ['MESSAGE' => 'Profile Created Successfully']);
                $this->redirect(array('/myProfile?uid='.$studentID));
                Yii::app()->end();
            }
        }
        $this->render('create_profile', compact('model'));
    }


    public function actionGetSchoolNames(){

        $term = Yii::app()->getRequest()->getParam('term', false);
        echo CJSON::encode(array_map(function($val){
            return array('id' => $val['school_id'], 'label' => $val['school_name'] );
        }, LookupSchool::getSchoolList($term)));
    }
}