<section id="section1" class="section">
	<style>
		.hidden{
			display: none !important;
		}
	</style>
	<div class="div-inner-gutter-space">
        <div class="row gutter_vertical">
			<h3 class="left">Students</h3>
		</div>

		<?php $form = $this->beginWidget('CActiveForm'); ?>
		<div class="row clearfix gutter_vertical">
			<div class="grid_3 left ">
				<?php
				echo $form->dropDownList(
					$model,'inst_id', CHtml::listData($model->getSchoolList(true), 'inst_ref_id', 'instRef.inst_name'),
					['empty' => 'All Schools', 'class' => 'select filterElement grid_3']
				);
				?>
			</div>
			<div class="grid_2 left">
				<?php
				echo $form->dropDownList(
					$model,'board_id', CHtml::listData($model->getBoardsList(), 'board_ref_id', 'boardRef.board_name'),
					['empty' => 'All Boards', 'class' => 'select filterElement grid_2']
				);
				?>
			</div>

			<div class="grid_2 left">
				<?php
				echo $form->dropDownList(
					$model,'passout_year', CHtml::listData($model->getYearsList(), 'passout_year', 'passout_year'),
					['empty' => 'Passout Year', 'class' => 'select filterElement grid_2']
				);
				?>
			</div>

			<div class="grid_3 left">
				<?php
				echo $form->textField($model,'student_name', ['class'=>'input grid_4 filterElement',
					'placeholder'=>'Search By Student Name OR Email', 'id'=>'search_by_name']);
				?>
			</div>
		</div>
		<?php $this->endWidget(); ?>

		<div class="clearfix gutter_vertical">
			<div class="row multi_line white" >
				<div class="grid_4 left">Student Name</div>
				<div class="grid_4 pull">Contact Info</div>
				<div class="grid_2 pull">Milestones</div>
			</div>

			<div class="row multi_line no-gutter visible">
				<?php
				$this->widget('zii.widgets.CListView', array(
					'dataProvider'=> $model->getStudentsList(),
					'itemView'=>'_students_listing_row',
					'template'=>"<table class='grid_view'><thead>{summary}\n{items}</thead></table>\n{pager}",
					'id'=>'ajaxListView','pager'=>array('header'=>'',),
					'emptyText' => '<center style="margin-top:25px">No students found</center>',
				));
				?>
			</div>
		</div>
	</div>
	<script>
        var delay = (function(){
            var timer = 0;
            return function(callback, ms){
                clearTimeout (timer);
                timer = setTimeout(callback, ms);
            };
        })();
        function updateGrid(){
            delay(function(){
                $.fn.yiiListView.update('ajaxListView', {  data: $('.filterElement').serialize()  });
            }, 500 );
        }
		$(function(){
			$('select.filterElement').change(updateGrid);
			$('#search_by_name').keyup(updateGrid);
		})
	</script>
</section>