<?php
    $this->renderPartial('//_pms_left_menu',array('active' => 'webinar'));
?>
<div class="content">
      
    <ul class="breadcrumb">
        <li><span>Manage Webinars</span></li>
    </ul>
    
    <?php
        foreach(Yii::app()->user->getFlashes() as $key => $message) {
            echo '<div style="padding:10px;margin-bottom:5px;" class="'. $key . '">' . $message . "</div>\n";
        }
    ?>    

    <ul class="nav nav-tabs">
        <li class="<?php echo $event_type?'':'active'; ?>"><a href="<?php echo $this->createUrl('index'); ?>">UPCOMING WEBINARS</a></li>
        <li class="<?php echo $event_type?'active':''; ?>"><a href="<?php echo $this->createUrl('index',array('event_type' => 1)); ?>">PAST WEBINARS</a></li>
    </ul>        
    
    <div class="container-fluid" style="width:850px">
        <div class="row-fluid">
            <?php 
                echo CHtml::textField('event_name', '', array('class' => 'pull-left input-xxlarge','placeholder' => 'Search by webinar name'));
            ?>
            <div id="loader" class="loading font75" style="display:none;float: left;">
                <img src="<?php echo Yii::app()->baseUrl ?>/themes/uni_avada/views/layouts/images/loader.gif" alt="loading..."/>
            </div>
        </div>
        <div class="row-fluid">
            <?php 
                $this->beginWidget('CActiveForm', array('id'=>'menu-dropdown-form','enableAjaxValidation'=>true,'method' => 'GET'));
                echo CHtml::dropDownList('country',$country_id,$data['countries'],array('empty' => 'ALL COUNTRIES'));
                echo CHtml::dropDownList('major',$major_id,$data['departments'],array('empty' => 'ALL MAJORS'));
                echo CHtml::dropDownList('counselor',$counselor,$data['presenters'],array('empty' => 'COUNSELOR NAME'));
                echo CHtml::ajaxSubmitButton(
                        'SEARCH', 
                        $this->createUrl('index',array('event_type' => $event_type)),
                        array(
                            'success' => 'js:function(data){$("#event_content").html(data)}'
                        ),
                        array('class' => "btn btn-primary", 'style' => 'margin: 1em 0;')
                     );
                $this->endWidget(); 
            ?>
        </div>

        
        <div id='event_content'>
        <?php foreach($data['Events'] as $country => $events): ?>
        <div style="border: 1px solid #EEE; padding: 5px; margin-bottom: 5px">
            <div class="row-fluid">
                <label class="pull-left"><?php echo strtoupper($country); ?></label>
                <a class="pull-right expand_event" href="javascript:void(0)" ><?php echo count($events).' webinar(s)' ?>&nbsp;&nbsp;<span class="icon-caret-down"></span></a>
            </div>
        </div>
        <div style="display: none;">
            <table class="table">
                <tr style="background: #F5F5F6">
                    <th>Title</th>
                    <th>Date</th>
                    <th>Presenter</th>
                    <th>Major</th>
                    <th>&nbsp;</th>
                </tr>
                <?php foreach($events as $e): ?>
                <tr>
                    <td>
                        <a href="<?php echo $this->createUrl('view',array('id' => $e['Event']['event_id'],'event_type' => $event_type)); ?>" title="view this event"><?php echo (strlen($e['Event']['event_title']) > 30) ? substr($e['Event']['event_title'],0,27).'...' : $e['Event']['event_title']; ?></a>
                    </td>
                    <td>
                        <?php
                            $start_time = DateTime::createFromFormat('Y-m-d H:i:s', $e['Event']['event_start_time'], new DateTimeZone('UTC'));
                            $start_time->setTimeZone(new DateTimeZone($e['Event']['timezone']));
                        ?>
                        <a href="<?php echo $this->createUrl('view',array('id' => $e['Event']['event_id'],'event_type' => $event_type)); ?>" title="view this event"><?php echo $start_time->format('l h:ia, jS M, Y'); ?></a>
                    </td>
                    <td>
                        <?php
                            echo isset($e['Event']['speaker_name'])?$e['Event']['speaker_name']:'';
                        ?>
                    </td>
                    <td>
                        <?php 
                            if(count($e['Department']) > 5){
                                echo 'Total '.count($e['Department']).' majors selected';
                            }else{
                                echo isset($e['Department'][0])?implode('<br />',$e['Department']):'';
                            }
                            
                        ?>
                    </td>
                    <td>
                        <a href='<?php echo $this->createUrl('edit',array('id' => $e['Event']['event_id'],'event_type' => $event_type)) ?>' title='Edit This Event'>Edit</a>
                    </td>
                </tr>
                <?php endforeach; ?>

            </table>
            
        </div>
        <?php endforeach; ?>
        </div>
        
        
        
    </div>
</div>
    
<script type='text/javascript'>
    
$(function(){
    $('a.expand_event').live('click',function(){
        $(this).parent().parent().next().toggle(250);
        $(this).children('span').toggleClass("icon-caret-down icon-caret-up");
    });

    var ajaxUpdateTimeout;
    var ajaxRequest;
   
    $('input#event_name').keyup(function(){
        ajaxRequest = $(this).serialize();
        clearTimeout(ajaxUpdateTimeout);
        ajaxUpdateTimeout = setTimeout(function(){
            $.ajax({
                url: '<?php echo $this->createUrl('index',array('event_type' => $event_type)); ?>',
                data: ajaxRequest,
                befireSend: $('#loader').show(),
                success: function(data){$('#event_content').html(data);$('#loader').hide();}
            });
        },300);
    });
        
});  
    
</script>